/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space.helper;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.CustomTrackingInputStream;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.FilteringUnicodeCharset;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.FilteringXmlInputStreamReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.commons.io.input.ReaderInputStream;

public class XMLHelper {
    private static final char INVALID_CHAR_PLACEHOLDER = '?';
    private SettingsManager settingsManager;

    public XMLHelper(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public InputStream getXmlInputStream(InputStream inputStream) {
        String encoding = this.settingsManager.getGlobalSettings().getDefaultEncoding();
        Charset charset = Charset.forName(encoding);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder.replaceWith(String.valueOf('?'));
        return new ReaderInputStream((Reader)new FilteringXmlInputStreamReader((InputStream)new CustomTrackingInputStream(inputStream), decoder, '?'), (Charset)new FilteringUnicodeCharset('?'), 0x400000);
    }
}

