/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import com.atlassian.migration.app.AppMigrationServiceClient;
import com.atlassian.migration.app.MultipartUploadStreamKt;
import com.atlassian.migration.app.dto.FinalizeUploadRequest;
import com.atlassian.migration.app.dto.GetUploadUrlRequest;
import com.atlassian.migration.app.dto.InitializeUploadResponse;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/migration/app/MultipartUploadStream;", "Ljava/io/ByteArrayOutputStream;", "amsClient", "Lcom/atlassian/migration/app/AppMigrationServiceClient;", "response", "Lcom/atlassian/migration/app/dto/InitializeUploadResponse;", "cloudId", "", "transferId", "chunkSizeBytes", "", "label", "Ljava/util/Optional;", "(Lcom/atlassian/migration/app/AppMigrationServiceClient;Lcom/atlassian/migration/app/dto/InitializeUploadResponse;Ljava/lang/String;Ljava/lang/String;ILjava/util/Optional;)V", "eTags", "", "s3Key", "uploadId", "attemptUpload", "", "bufferContentToMd5ToBase64", "chunkIndex", "close", "elapsed", "", "start", "Ljava/time/Instant;", "getSignedUrlAndUpload", "write", "b", "", "off", "len", "app-migration-assistant"})
public final class MultipartUploadStream
extends ByteArrayOutputStream {
    @NotNull
    private final AppMigrationServiceClient amsClient;
    @NotNull
    private final String cloudId;
    @NotNull
    private final String transferId;
    private final int chunkSizeBytes;
    @NotNull
    private final Optional<String> label;
    @NotNull
    private final String s3Key;
    @NotNull
    private final String uploadId;
    @NotNull
    private final List<String> eTags;

    public MultipartUploadStream(@NotNull AppMigrationServiceClient amsClient, @NotNull InitializeUploadResponse response, @NotNull String cloudId, @NotNull String transferId, int chunkSizeBytes, @NotNull Optional<String> label) {
        Intrinsics.checkNotNullParameter((Object)amsClient, (String)"amsClient");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cloudId, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)transferId, (String)"transferId");
        Intrinsics.checkNotNullParameter(label, (String)"label");
        this.amsClient = amsClient;
        this.cloudId = cloudId;
        this.transferId = transferId;
        this.chunkSizeBytes = chunkSizeBytes;
        this.label = label;
        this.s3Key = response.getS3Key();
        this.uploadId = response.getUploadId();
        this.eTags = new ArrayList();
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
        this.attemptUpload();
    }

    @Override
    public synchronized void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        super.write(b, off, len);
        this.attemptUpload();
    }

    @Override
    public synchronized void close() {
        MultipartUploadStreamKt.access$getLog$p().debug("Closing multipart upload stream for count={}", (Object)this.count);
        long seconds = 0L;
        if (this.count > 0) {
            seconds = this.getSignedUrlAndUpload();
        }
        this.amsClient.finalizeUpload(this.cloudId, new FinalizeUploadRequest(this.s3Key, this.eTags, this.uploadId, this.transferId, (String)this.label.orElse(null)));
        Object[] objectArray = new Object[]{StringUtils.abbreviate((String)this.transferId, (int)21), this.label, this.eTags.size(), seconds};
        MultipartUploadStreamKt.access$getLog$p().info("Finalized multipart upload for app-migration for transferId {} and label \"{}\", uploaded {} chunks in {} seconds", objectArray);
    }

    private final void attemptUpload() {
        if (this.count >= this.chunkSizeBytes) {
            this.getSignedUrlAndUpload();
        }
    }

    private final long getSignedUrlAndUpload() {
        Instant start = Instant.now();
        int index = this.chunkIndex();
        String md5Sum = this.bufferContentToMd5ToBase64();
        int contentLength = this.size();
        MultipartUploadStreamKt.access$getLog$p().debug("Getting signed url and upload for index={}, md5Sum={}", (Object)index, (Object)md5Sum);
        UUID uUID = UUID.fromString(this.transferId);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(transferId)");
        String url = this.amsClient.getMultipartUploadUrl(this.cloudId, new GetUploadUrlRequest(uUID, this.s3Key, this.uploadId, index, md5Sum, contentLength));
        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
        long getUrlElapsedTime = this.elapsed(start);
        MultipartUploadStreamKt.access$getLog$p().debug("transferId={}, upload url seconds={}", (Object)StringUtils.abbreviate((String)this.transferId, (int)21), (Object)getUrlElapsedTime);
        Instant startUploadtime = Instant.now();
        byte[] byArray = this.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray()");
        String eTag = this.amsClient.uploadToS3(url, md5Sum, byArray);
        int size = contentLength / 1024;
        Intrinsics.checkNotNullExpressionValue((Object)startUploadtime, (String)"startUploadtime");
        long uploadToS3ElapsedTime = this.elapsed(startUploadtime);
        Object[] objectArray = new Object[]{index, size, eTag, uploadToS3ElapsedTime};
        MultipartUploadStreamKt.access$getLog$p().debug("chunk={}, kb size={}, eTag={}, upload to s3 seconds={}", objectArray);
        this.eTags.add(eTag);
        this.reset();
        long totalElapsedTime = this.elapsed(start);
        return totalElapsedTime;
    }

    private final int chunkIndex() {
        return this.eTags.size() + 1;
    }

    private final String bufferContentToMd5ToBase64() {
        String string;
        try {
            MessageDigest md5digest = MessageDigest.getInstance("MD5");
            md5digest.update(this.buf, 0, this.size());
            byte[] md5hash = md5digest.digest();
            String string2 = Base64.getEncoder().encodeToString(md5hash);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            val md5dig\u2026String(md5hash)\n        }");
            string = string2;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    private final long elapsed(Instant start) {
        return Duration.between(start, Instant.now()).getSeconds();
    }
}

