/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.migration.agent.service.stepexecutor.space.PostprocessingIOUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.XMLEventUtil;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.jodah.failsafe.function.CheckedFunction;

public class ContentIdsXmlExtractor {
    private static final Set<String> CONFLUENCE_CONTENT_CLASSES = Sets.newHashSet((Object[])new String[]{"Page", "BlogPost"});
    private final XMLInputFactory inputFactory = XMLInputFactory.newFactory();
    private final XMLOutputFactory outputFactory;

    public ContentIdsXmlExtractor() {
        this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.outputFactory = XMLOutputFactory.newFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> extractContentIds(InputStream in, OutputStream out) throws Throwable {
        XMLEventReader reader = null;
        ArrayList<Long> contentIds = new ArrayList<Long>();
        try {
            reader = this.inputFactory.createXMLEventReader(in);
            XMLEventWriter writer = this.outputFactory.createXMLEventWriter(out);
            XMLEventProcessor currentProcessor = this::processUntilNextContentObject;
            while (reader.hasNext()) {
                currentProcessor = (XMLEventProcessor)currentProcessor.apply(new ContentIdExtractingContext(reader, writer, reader.nextEvent(), contentIds));
            }
        }
        finally {
            if (reader != null) {
                PostprocessingIOUtil.runQuietly(reader::close);
            }
        }
        return contentIds;
    }

    private XMLEventProcessor processUntilNextContentObject(ContentIdExtractingContext context) throws XMLStreamException {
        StartElement element;
        if (context.event.isStartElement() && XMLEventUtil.hasLocalName(element = context.event.asStartElement(), "object") && CONFLUENCE_CONTENT_CLASSES.contains(XMLEventUtil.getAttributeValue(element, "class"))) {
            return this.extractContentId(context);
        }
        context.writer.add(context.event);
        return this::processUntilNextContentObject;
    }

    private XMLEventProcessor extractContentId(ContentIdExtractingContext context) throws XMLStreamException {
        XMLEvent xmlEvent = context.event;
        context.writer.add(xmlEvent);
        if (xmlEvent.isStartElement() && XMLEventUtil.hasLocalName(xmlEvent.asStartElement(), "id") && XMLEventUtil.hasAttribute(xmlEvent.asStartElement(), "name", "id")) {
            if (context.reader.peek().isCharacters()) {
                XMLEvent innerEvent = context.reader.nextEvent();
                context.writer.add(innerEvent);
                String contentId = innerEvent.asCharacters().getData();
                context.addContentId(Long.parseLong(contentId));
            }
            return this::processUntilNextContentObject;
        }
        if (context.event.isEndElement() && XMLEventUtil.hasLocalName(context.event.asEndElement(), "object")) {
            return this::processUntilNextContentObject;
        }
        return this::extractContentId;
    }

    private static final class ContentIdExtractingContext {
        final XMLEvent event;
        final XMLEventReader reader;
        final XMLEventWriter writer;
        final List<Long> contentIds;

        ContentIdExtractingContext(XMLEventReader reader, XMLEventWriter writer, XMLEvent event, List<Long> contentIds) {
            this.reader = reader;
            this.writer = writer;
            this.event = event;
            this.contentIds = contentIds;
        }

        void addContentId(Long contentId) {
            this.contentIds.add(contentId);
        }
    }

    private static interface XMLEventProcessor
    extends CheckedFunction<ContentIdExtractingContext, XMLEventProcessor> {
    }
}

