/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mapi.executor;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.dto.CloudSiteDto;
import com.atlassian.migration.agent.dto.CloudType;
import com.atlassian.migration.agent.dto.ConfluenceSpaceTaskDto;
import com.atlassian.migration.agent.dto.MigrateAppsTaskDto;
import com.atlassian.migration.agent.dto.MigrateUsersTaskDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.SpaceAttachmentsTaskDto;
import com.atlassian.migration.agent.dto.TaskDto;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentUpdateRequest;
import com.atlassian.migration.agent.entity.AppAssessmentProperty;
import com.atlassian.migration.agent.entity.AppAssessmentUserAttributedStatus;
import com.atlassian.migration.agent.entity.MapiPlanMapping;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.entity.PlanActiveStatus;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.mapi.MigrationCreator;
import com.atlassian.migration.agent.mapi.executor.CloudExecutorService;
import com.atlassian.migration.agent.mapi.external.MapiMigrationService;
import com.atlassian.migration.agent.mapi.external.model.JobValidationException;
import com.atlassian.migration.agent.mapi.external.model.PublicApiException;
import com.atlassian.migration.agent.mapi.job.JobDefinition;
import com.atlassian.migration.agent.mapi.job.JobValidationService;
import com.atlassian.migration.agent.mapi.job.scope.ScopeMode;
import com.atlassian.migration.agent.mapi.job.scope.SpaceMode;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.app.PluginManager;
import com.atlassian.migration.agent.service.impl.AppAssessmentFacade;
import com.atlassian.migration.agent.service.impl.MapiPlanMappingService;
import com.atlassian.migration.agent.service.impl.PlanDecoratorService;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class CloudExecutorServiceImpl
implements CloudExecutorService {
    private PlanDecoratorService planDecoratorService;
    private MapiMigrationService mapiMigrationService;
    private JobValidationService jobValidationService;
    private AnalyticsEventService analyticsEventService;
    private AnalyticsEventBuilder analyticsEventBuilder;
    private AppAssessmentFacade appAssessmentFacade;
    private MapiPlanMappingService mapiPlanMappingService;
    private SpaceManager spaceManager;
    private PluginManager pluginManager;
    private static final Logger log = ContextLoggerFactory.getLogger(CloudExecutorServiceImpl.class);
    private static final String INVALID_APPS_EXCEPTION = "Migration includes invalid app keys = %s. These apps do not exist in the server. Please remove these apps from the job definition and try again.";

    public CloudExecutorServiceImpl(PlanDecoratorService planDecoratorService, MapiMigrationService mapiMigrationService, JobValidationService jobValidationService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, AppAssessmentFacade appAssessmentFacade, MapiPlanMappingService mapiPlanMappingService, SpaceManager spaceManager, PluginManager pluginManager) {
        this.planDecoratorService = planDecoratorService;
        this.mapiMigrationService = mapiMigrationService;
        this.jobValidationService = jobValidationService;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.appAssessmentFacade = appAssessmentFacade;
        this.mapiPlanMappingService = mapiPlanMappingService;
        this.spaceManager = spaceManager;
        this.pluginManager = pluginManager;
    }

    @Override
    public PlanDto createPlan(String jobId) {
        if (this.mapiPlanMappingService.getMapiPlanMapping(jobId).isPresent()) {
            log.info("Plan already created for the jobId: {}", (Object)jobId);
            throw new PublicApiException.DuplicateRequestException(jobId);
        }
        PlanDto planDto = this.planDecoratorService.createPlan(this.buildPlanDto(jobId));
        MapiPlanMapping mapiPlanMapping = new MapiPlanMapping(jobId, planDto.getId(), null);
        this.mapiPlanMappingService.saveMapiPlanMapping(mapiPlanMapping);
        log.info("Plan created for the jobId: {} planId: {} ", (Object)jobId, (Object)planDto.getId());
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        this.analyticsEventService.sendAnalyticsEventsAsync(() -> this.analyticsEventBuilder.buildCreatePlanAndTasksAnalyticsEvents(planDto, confluenceUser, Optional.of(jobId)));
        return planDto;
    }

    @VisibleForTesting
    public PlanDto buildPlanDto(String jobId) {
        log.info("Plan creation started for the jobId: {}", (Object)jobId);
        JobDefinition jobDefinition = this.mapiMigrationService.getMigrationJobDefinition(jobId, Optional.empty());
        this.jobValidationService.validateJobDefinition(jobDefinition);
        List<TaskDto> taskDtos = this.populatePlanTasks(jobDefinition);
        log.info("Tasks created for the jobId: {} taskDtos: {}", (Object)jobId, taskDtos);
        return new PlanDto(null, UUID.randomUUID().toString(), jobDefinition.getName(), Instant.now(), Instant.now(), new CloudSiteDto(jobDefinition.getDestination().getUrl(), jobDefinition.getDestination().getCloudId(), null, CloudType.STANDARD), taskDtos, null, null, PlanActiveStatus.ACTIVE, null, MigrationTag.NOT_SPECIFIED, MigrationCreator.MAPI);
    }

    private List<String> getIncludedSpaceKeysForPlan(List<String> providedSpaceKeys) {
        Map<String, String> allSpaceKeysMap = this.spaceManager.getAllSpaces().stream().map(Space::getKey).collect(Collectors.toMap(StringUtils::lowerCase, spaceKey -> spaceKey));
        return providedSpaceKeys.stream().map(spaceKey -> allSpaceKeysMap.getOrDefault(StringUtils.lowerCase((String)spaceKey), (String)spaceKey)).collect(Collectors.toList());
    }

    private AppAssessmentUpdateRequest buildAppAssessmentUpdateRequest(String appKey) {
        return new AppAssessmentUpdateRequest(appKey, AppAssessmentProperty.MIGRATION_STATUS.getName(), AppAssessmentUserAttributedStatus.Needed.name());
    }

    @VisibleForTesting
    public List<TaskDto> populatePlanTasks(JobDefinition mapiJobDefinition) {
        LinkedList<TaskDto> taskDtos = new LinkedList<TaskDto>();
        boolean isAttachmentOnly = mapiJobDefinition.getScope().getSpaces().getIncludedData() == SpaceMode.ATTACHMENTS;
        List<String> includedSpaceKeys = this.getIncludedSpaceKeysForPlan(mapiJobDefinition.getScope().getSpaces().getIncludedKeys());
        includedSpaceKeys.forEach(spaceKey -> {
            if (isAttachmentOnly) {
                taskDtos.add(new SpaceAttachmentsTaskDto(null, null, (String)spaceKey, null, 0L, null));
            } else {
                taskDtos.add(new ConfluenceSpaceTaskDto(null, null, (String)spaceKey, null, 0L, null));
            }
        });
        if (!isAttachmentOnly) {
            boolean isScoped = mapiJobDefinition.getScope().getUsersAndGroups().getMode() == ScopeMode.REFERENCED;
            taskDtos.add(new MigrateUsersTaskDto(null, null, 0L, null, isScoped));
            if (mapiJobDefinition.getScope().getApps() != null && !CollectionUtils.isEmpty(mapiJobDefinition.getScope().getApps().getIncludedKeys())) {
                Set providedAppKeys = mapiJobDefinition.getScope().getApps().getIncludedKeys().stream().map(StringUtils::lowerCase).collect(Collectors.toSet());
                Set actuallyInstalledAppKeys = this.pluginManager.getActualUserInstalledPlugins().stream().map(plugin -> StringUtils.lowerCase((String)plugin.getKey())).collect(Collectors.toSet());
                HashSet<String> appKeysTobeExcluded = new HashSet<String>();
                appKeysTobeExcluded.addAll(providedAppKeys.stream().filter(appKey -> !actuallyInstalledAppKeys.contains(appKey)).collect(Collectors.toSet()));
                if (!appKeysTobeExcluded.isEmpty()) {
                    throw new JobValidationException(String.format(INVALID_APPS_EXCEPTION, appKeysTobeExcluded));
                }
                Set<String> appKeysTobeIncluded = actuallyInstalledAppKeys.stream().filter(appKey -> {
                    if (providedAppKeys.contains(appKey)) {
                        AppAssessmentUpdateRequest appAssessmentUpdateRequest = this.buildAppAssessmentUpdateRequest((String)appKey);
                        this.appAssessmentFacade.updateAppAssessmentInfo((String)appKey, appAssessmentUpdateRequest);
                        return true;
                    }
                    appKeysTobeExcluded.add((String)appKey);
                    return false;
                }).collect(Collectors.toSet());
                log.info("App keys that are excluded from the plan: {}", appKeysTobeExcluded);
                MigrateAppsTaskDto migrateAppsTaskDto = new MigrateAppsTaskDto(null, null, appKeysTobeExcluded, null);
                migrateAppsTaskDto.setNeededInCloudApps(appKeysTobeIncluded);
                taskDtos.add(migrateAppsTaskDto);
            }
        }
        return taskDtos;
    }
}

