/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

public class SpaceStatisticCalculationQueries {
    static final String JPQL_SPACE_ID_QUERY = "select s.id as id from Space s";
    static final String JPQL_MISSING_SPACE_ID_QUERY = "select s.id as id from Space s left join SpaceStatistic st on s.id = st.spaceId where st.spaceId is null";
    static final String FROM_CONTENT_TABLE_PLACE_HOLDER_NAME = "CONTENT_TABLE_PLACE_HOLDER";
    static final String MIGRATIONS_RUNNING_COUNT_QUERY = "select count(plan) from Plan plan where plan.progress.status= 'RUNNING'";
    static final String FROM_CONTENT_TABLE_INCLUDING_HISTORICAL_DATA_TEMPLATE = "from (\nselect CONTENTID, CONTENTTYPE, SPACEID, LASTMODDATE\n             from CONTENT\n             where SPACEID in\n                   (:spaceIds)\n             union\n             select historicalContent.contentId , historicalContent.contentType, historicalContent.spaceId, historicalContent.lastModDate\n             from (select a.CONTENTID as contentId, a.CONTENTTYPE as contentType, b.SPACEID as spaceId, a.LASTMODDATE as lastModDate\n                   from CONTENT a\n                   inner join CONTENT b on a.PREVVER = b.CONTENTID\n                   where a.PREVVER in (select CONTENTID\n                                       from CONTENT\n                                       where SPACEID in\n                                             (:spaceIds)\n                                         )\n                         and a.SPACEID is NULL\n                     ) historicalContent) c\n       group by c.SPACEID\n";
    static final String FROM_CONTENT_TABLE_EXCLUDING_HISTORICAL_DATA_TEMPLATE = " from CONTENT c\n where c.SPACEID in (:spaceIds)\n group by c.SPACEID \n";
    static final String CALCULATE_SPACE_STATISTICS_TEMPLATE = "select \n     sb.spaceId,\n     COALESCE(csq.sumOfPageBlogDraftCount, 0)  as sumOfPageBlogDraftCount,\n     COALESCE(csq.attachmentCount, 0)  as attachmentCount,\n     COALESCE(asq.attachmentSize, 0) as attachmentSize,\n     CASE\n          WHEN sb.lastUpdated is null then csq.lastUpdated\n          WHEN csq.lastUpdated is null then sb.lastUpdated\n          WHEN csq.lastUpdated > sb.lastUpdated then csq.lastUpdated\n          ELSE sb.lastUpdated\n       END as lastUpdated,\n     CURRENT_TIMESTAMP as lastCalculated\n from ( \n   select LASTMODDATE as lastUpdated, SPACEID as spaceId from SPACES where SPACEID in (:spaceIds)\n ) sb\n left join\n         (select SUM(CASE WHEN c.CONTENTTYPE in ('PAGE', 'BLOGPOST') THEN 1 ELSE 0 END) as sumOfPageBlogDraftCount,\n              SUM(CASE WHEN c.CONTENTTYPE = 'ATTACHMENT' THEN 1 ELSE 0 END)      as attachmentCount,\n              MAX(LASTMODDATE)                                                   as lastUpdated,\n              SPACEID                                                            as spaceId\nCONTENT_TABLE_PLACE_HOLDER ) csq  on csq.spaceId = sb.spaceId\n left join\n      (select SUM(cp.LONGVAL) as attachmentSize, c.SPACEID as spaceId\n          from CONTENT c\n                   join CONTENTPROPERTIES cp on c.CONTENTID = cp.CONTENTID\n          where cp.PROPERTYNAME = 'FILESIZE'\n            and c.CONTENTTYPE = 'ATTACHMENT'\n            and SPACEID in (:spaceIds)\n          group by c.SPACEID) asq on asq.spaceId = sb.spaceId";
    static final String CALCULATE_SPACE_STATISTIC_WITH_HISTORICAL_PAGES_USING_CTE = "with ContentBase as (select SPACEID, CONTENTID, LASTMODDATE, PREVVER, CONTENTTYPE\n              from CONTENT\n              where SPACEID in (:spaceIds)\n                and CONTENTTYPE in ('PAGE', 'BLOGPOST', 'ATTACHMENT', 'SPACEDESCRIPTION')),\n     SpacesBase as (select SPACEID, LASTMODDATE from SPACES where SPACEID in (:spaceIds)),\n     AllPageContent as (select SPACEID, CONTENTID, LASTMODDATE\n                        from ContentBase\n                        where CONTENTTYPE in ('PAGE', 'BLOGPOST')\n                        union\n                        select cb.SPACEID, c.CONTENTID, c.LASTMODDATE\n                        from CONTENT c\n                                 inner join ContentBase cb on cb.CONTENTID = c.PREVVER\n                                                      and c.SPACEID is null\n                                                     and c.PREVVER in (select CONTENTID from ContentBase where ContentBase.CONTENTTYPE in ('PAGE', 'BLOGPOST'))),\n     PageStat as (select count(*) as sumOfPageBlogDraftCount, SPACEID\n                  from AllPageContent\n                  group by SPACEID),\n     AttachmentStat as (select SUM(cp.LONGVAL) as attachmentSize, count(SPACEID) as attachmentCount, SPACEID\n                        from ContentBase cb\n                        join CONTENTPROPERTIES cp on cb.CONTENTID = cp.CONTENTID\n                        where cp.PROPERTYNAME = 'FILESIZE' and cb.CONTENTTYPE = 'ATTACHMENT'\n                        group by SPACEID),\n     RecentEdit as (select (CASE\n                                WHEN MAX(sb.LASTMODDATE) is null then MAX(cb.LASTMODDATE)\n                                WHEN MAX(cb.LASTMODDATE) is null then  MAX(sb.LASTMODDATE)\n                                WHEN  MAX(sb.LASTMODDATE) > MAX(cb.LASTMODDATE) then MAX(cb.LASTMODDATE)\n                                ELSE MAX(cb.LASTMODDATE)\n         END) as lastUpdated,\n                                  sb.SPACEID as SPACEID\n                           from ContentBase cb\n                           join SpacesBase sb on sb.SPACEID = cb.SPACEID\n                           group by sb.SPACEID)\nselect sb.SPACEID as spaceId, COALESCE(sumOfPageBlogDraftCount, 0) as sumOfPageBlogDraftCount, COALESCE(attachmentCount, 0) as attachmentCount, COALESCE(attachmentSize, 0) as attachmentSize, lastUpdated, CURRENT_TIMESTAMP as lastCalculated\nfrom SpacesBase sb\n         left join PageStat p on p.SPACEID = sb.SPACEID\n         left join AttachmentStat a on a.SPACEID = sb.SPACEID\n         left join RecentEdit r on r.SPACEID = sb.SPACEID";

    private SpaceStatisticCalculationQueries() {
    }
}

