/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mapi.external.model;

public class PublicApiException
extends RuntimeException {
    public static final String GENERIC_EXCEPTION = "Please check Confluence Logs to find the issue or contact support, if the issue persists.";
    private static final String RESPONSE_PARSING_ERROR_MESSAGE = "Json Parsing Failed for jobId = %s.\n(1) Make sure that you have the latest CCMA version installed.\n(2) Check Confluence Logs or contact support, if the issue persists.";
    private static final String DUPLICATE_JOB_MESSAGE = "Attach Request has already been processed for JobId = %s";

    public PublicApiException() {
        super(GENERIC_EXCEPTION);
    }

    public PublicApiException(String message) {
        super(message);
    }

    public PublicApiException(String message, Exception exception) {
        super(message, exception);
    }

    public static class DuplicateRequestException
    extends PublicApiException {
        public DuplicateRequestException(String jobId) {
            super(String.format(PublicApiException.DUPLICATE_JOB_MESSAGE, jobId));
        }
    }

    public static class MigrationDefinitionParsingError
    extends PublicApiException {
        public MigrationDefinitionParsingError(String jobId, Exception exception) {
            super(String.format(PublicApiException.RESPONSE_PARSING_ERROR_MESSAGE, jobId), exception);
        }
    }
}

