/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.results.TablesPerPageQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;

public class SizeOfTablesPerPageQuery
implements GrQuery<TablesPerPageQueryResult>,
L1AssessmentQuery<TablesPerPageQueryResult> {
    private final EntityManagerTemplate tmpl;
    private final RecentlyViewedManager recentlyViewedManager;

    public SizeOfTablesPerPageQuery(EntityManagerTemplate tmpl, RecentlyViewedManager recentlyViewedManager) {
        this.tmpl = tmpl;
        this.recentlyViewedManager = recentlyViewedManager;
    }

    @Override
    public String getQueryId() {
        return QueryIds.SIZE_OF_TABLES_PER_PAGE.name();
    }

    @Override
    public TablesPerPageQueryResult execute() {
        String query = "select content.id as page_id, (length(bc.body) - length(replace(bc.body, '<td>', ''))) / length('<td>') as table_size, content.version as page_edit_frequency from Content content inner join BodyContent bc on content.id = bc.contentId where content.type in ('PAGE', 'BLOGPOST') and content.status in ('current', 'draft') and content.previousVersion is null";
        List<Tuple> result = this.tmpl.query(Tuple.class, query).list();
        return new TablesPerPageQueryResult(result, this.recentlyViewedManager);
    }
}

