/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.GuardrailsQueries;
import com.atlassian.migration.agent.store.guardrails.results.PageDepthQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import java.util.List;
import javax.persistence.Tuple;

public class PageDepthQuery
implements GrQuery<PageDepthQueryResult>,
L1AssessmentQuery<PageDepthQueryResult> {
    private static final int LIMIT = 100;
    private final EntityManagerTemplate tmpl;
    private final DialectResolver dialectResolver;

    public PageDepthQuery(EntityManagerTemplate tmpl, DialectResolver dialectResolver) {
        this.tmpl = tmpl;
        this.dialectResolver = dialectResolver;
    }

    @Override
    public String getQueryId() {
        return QueryIds.PAGE_TREE_DEPTH.name();
    }

    @Override
    public PageDepthQueryResult execute() {
        String query = this.getPageDepthQueryForCurrentDb();
        if (String.valueOf(query).isEmpty()) {
            return new PageDepthQueryResult(null);
        }
        List<Tuple> dbResult = this.tmpl.nativeQuery(Tuple.class, query).max(100).list();
        return new PageDepthQueryResult(dbResult);
    }

    protected String getPageDepthQueryForCurrentDb() {
        DbType dbType = this.dialectResolver.getDbType();
        return GuardrailsQueries.PAGE_DEPTH_QUERY.query(dbType);
    }
}

