/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.results.TotalPagesPerSpaceQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;

public class TotalPagesPerSpaceQuery
implements GrQuery<TotalPagesPerSpaceQueryResult>,
L1AssessmentQuery<TotalPagesPerSpaceQueryResult> {
    private static final int LIMIT = 100;
    private final EntityManagerTemplate tmpl;

    public TotalPagesPerSpaceQuery(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public String getQueryId() {
        return QueryIds.TOTAL_PAGES_PER_SPACE.name();
    }

    @Override
    public TotalPagesPerSpaceQueryResult execute() {
        String query = "select c.spaceId as space_id, s.key as space_key, count(*) as page_count from Content c inner join Space s on c.spaceId = s.id where c.type = 'PAGE' and c.previousVersion is null group by c.spaceId, s.key order by page_count desc";
        List<Tuple> result = this.tmpl.query(Tuple.class, query).max(100).list();
        return new TotalPagesPerSpaceQueryResult(result);
    }
}

