/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvOutputStreamResult;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentCSVService;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentService;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.JobWithStatus;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.time.LocalDate;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@Path(value="instance/assessment/job")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InstanceAssessmentResource {
    private final InstanceAssessmentService instanceAssessmentService;
    private final InstanceAssessmentCSVService instanceAssessmentCSVService;
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentResource.class);

    public InstanceAssessmentResource(InstanceAssessmentService instanceAssessmentService, InstanceAssessmentCSVService instanceAssessmentCSVService) {
        this.instanceAssessmentService = instanceAssessmentService;
        this.instanceAssessmentCSVService = instanceAssessmentCSVService;
    }

    @GET
    @Path(value="/schedule")
    public Response scheduleNewAssessment() {
        try {
            JobWithStatus jobWithStatus = this.instanceAssessmentService.scheduleInstanceAssessment();
            return Response.ok((Object)jobWithStatus).build();
        }
        catch (Exception e) {
            log.warn("Exception:", (Throwable)e);
            JobWithStatus jobWithStatus = new JobWithStatus(null, InstanceAssessmentStatus.FAILED, null);
            return Response.ok((Object)jobWithStatus).build();
        }
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/{jobId}/csv")
    public Response downloadCSV(@PathParam(value="jobId") String jobId) {
        String fileName = "confluence-migration-assessment-".concat(String.valueOf(LocalDate.now()));
        StreamingOutput stream = output -> {
            GuardrailsCsvOutputStreamResult result = this.instanceAssessmentCSVService.generate(jobId, fileName, output);
            if (result.getError() != null) {
                throw new WebApplicationException(result.getError());
            }
        };
        return Response.ok((Object)stream).type("application/zip").header("Content-disposition", (Object)String.format("attachment; filename=%s.zip", fileName)).build();
    }

    @GET
    @Path(value="/{jobId}")
    public Response getJobProgress(@PathParam(value="jobId") String jobId) {
        JobWithStatus jobWithStatus = this.instanceAssessmentService.processJobProgress(jobId);
        return Response.ok((Object)jobWithStatus).build();
    }

    @GET
    @Path(value="/actives")
    public Response getActiveAssessment() {
        JobWithStatus jobWithStatus = this.instanceAssessmentService.activeAssessment();
        return Response.ok((Object)jobWithStatus).build();
    }
}

