/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.results.TablesPerPageQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;

public class NumberOfTablesPerPageQuery
implements GrQuery<TablesPerPageQueryResult>,
L1AssessmentQuery<TablesPerPageQueryResult> {
    private final EntityManagerTemplate tmpl;

    public NumberOfTablesPerPageQuery(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public String getQueryId() {
        return QueryIds.NUMBER_OF_TABLES_PER_PAGE.name();
    }

    @Override
    public TablesPerPageQueryResult execute() {
        String query = "select content.id as page_id, (length(bc.body) - length(replace(bc.body, '</table>', ''))) / length('</table>') as table_count from Content content inner join BodyContent bc on content.id = bc.contentId where content.type = 'PAGE' and content.previousVersion is null";
        List<Tuple> result = this.tmpl.query(Tuple.class, query).list();
        return new TablesPerPageQueryResult(result);
    }
}

