/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.results.EmbeddedAttPerPageQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;
import org.slf4j.Logger;

public class EmbeddedAttPerPageQuery
implements GrQuery<EmbeddedAttPerPageQueryResult>,
L1AssessmentQuery<EmbeddedAttPerPageQueryResult> {
    private static final Logger log = ContextLoggerFactory.getLogger(EmbeddedAttPerPageQuery.class);
    private static final int LIMIT = 100;
    private final EntityManagerTemplate tmpl;
    private final BootstrapManager bootstrapManager;

    public EmbeddedAttPerPageQuery(EntityManagerTemplate tmpl, BootstrapManager bootstrapManager) {
        this.tmpl = tmpl;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public String getQueryId() {
        return QueryIds.EMBEDDED_ATT_PER_PAGE.name();
    }

    @Override
    public EmbeddedAttPerPageQueryResult execute() {
        String query = this.getEmbeddedAttPerPageQuery();
        List<Tuple> result = this.tmpl.query(Tuple.class, query).max(100).list();
        return new EmbeddedAttPerPageQueryResult(result);
    }

    String getEmbeddedAttPerPageQuery() {
        try {
            ApplicationConfiguration applicationConfig = this.bootstrapManager.getApplicationConfig();
            String dialect = (String)applicationConfig.getProperty((Object)"hibernate.dialect");
            log.info("Resolved hibernate dialect: {}", (Object)dialect);
            if (dialect != null && dialect.toLowerCase().contains("sqlserver")) {
                return "select content.id as page_id, (length(cast(bc.body as text)) - length(replace(cast(bc.body as text), '<ri:attachment', ''))) / length('<ri:attachment') as attachment_count  from Content content inner join BodyContent bc on content.id = bc.contentId  where content.previousVersion is null  order by attachment_count desc";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "select content.id as page_id, (length(bc.body) - length(replace(bc.body, '<ri:attachment', ''))) / length('<ri:attachment') as attachment_count  from Content content inner join BodyContent bc on content.id = bc.contentId  where content.previousVersion is null  order by attachment_count desc";
    }
}

