/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.impl.UserService;
import com.atlassian.migration.agent.service.stepexecutor.space.PostprocessingIOUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.XMLEventUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.XMLHelper;
import com.atlassian.migration.agent.service.version.ConfluenceServerVersion;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.jodah.failsafe.function.CheckedFunction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SpaceExportPostProcessor {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportPostProcessor.class);
    private static final String GDPR_CONFLUENCE_VERSION = "6.14.0";
    private static final String ENTITIES_XML_ZIP_ENTRY_NAME = "entities.xml";
    private static final String EXPORT_DESCRIPTOR_ENTRY_NAME = "exportDescriptor.properties";
    private final UserService userService;
    private final boolean isGDPRReadyServer;
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private final PluginVersionManager pluginVersionManager;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final XMLHelper xmlHelper;

    public SpaceExportPostProcessor(UserService userService, SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, XMLHelper xmlHelper) {
        this(userService, sysInfoService, pluginVersionManager, Instant::now, analyticsEventService, analyticsEventBuilder, xmlHelper);
    }

    @VisibleForTesting
    public SpaceExportPostProcessor(UserService userService, SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, XMLHelper xmlHelper) {
        this.userService = userService;
        this.pluginVersionManager = pluginVersionManager;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.xmlHelper = xmlHelper;
        this.isGDPRReadyServer = SpaceExportPostProcessor.isGDPRReadyServer(sysInfoService.getConfluenceInfo().getVersion());
        if (this.isGDPRReadyServer) {
            this.inputFactory = null;
            this.outputFactory = null;
            this.eventFactory = null;
        } else {
            this.inputFactory = XMLInputFactory.newFactory();
            this.outputFactory = XMLOutputFactory.newFactory();
            this.eventFactory = XMLEventFactory.newFactory();
            this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void postprocess(Path exportFile, String spaceKey, String planId, String taskId, boolean usersCreatedInUMS) {
        block45: {
            boolean success;
            Path modifiedExportFile;
            long startTime;
            block43: {
                startTime = this.instantSupplier.get().toEpochMilli();
                if (this.isGDPRReadyServer) {
                    this.buildAndSaveTimerEvent(true, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, planId, taskId, true);
                    return;
                }
                modifiedExportFile = null;
                success = false;
                modifiedExportFile = Files.createTempFile(exportFile.getParent(), null, null, new FileAttribute[0]);
                try (ZipFile in = new ZipFile(exportFile.toFile());
                     ZipOutputStream out = new ZipOutputStream(IOUtils.buffer((OutputStream)Files.newOutputStream(modifiedExportFile, new OpenOption[0])));){
                    Enumeration<? extends ZipEntry> entries = in.entries();
                    while (entries.hasMoreElements()) {
                        InputStream entryInputStream;
                        block41: {
                            ZipEntry entry = entries.nextElement();
                            out.putNextEntry(PostprocessingIOUtil.copyEntry(entry));
                            entryInputStream = in.getInputStream(entry);
                            try {
                                if (ENTITIES_XML_ZIP_ENTRY_NAME.equals(entry.getName())) {
                                    this.postprocessEntities(this.xmlHelper.getXmlInputStream(entryInputStream), out);
                                    break block41;
                                }
                                if (EXPORT_DESCRIPTOR_ENTRY_NAME.equals(entry.getName())) {
                                    this.postprocessDescriptor(entryInputStream, out, usersCreatedInUMS);
                                    break block41;
                                }
                                IOUtils.copy((InputStream)entryInputStream, (OutputStream)out);
                            }
                            catch (Throwable throwable) {
                                PostprocessingIOUtil.runQuietly(entryInputStream::close);
                                throw throwable;
                            }
                        }
                        PostprocessingIOUtil.runQuietly(entryInputStream::close);
                        out.closeEntry();
                    }
                }
                Files.move(modifiedExportFile, exportFile, StandardCopyOption.REPLACE_EXISTING);
                success = true;
                if (modifiedExportFile == null) break block43;
                try {
                    Files.deleteIfExists(modifiedExportFile);
                }
                catch (IOException e) {
                    log.warn("Couldn't delete temp file", (Throwable)e);
                }
            }
            this.buildAndSaveTimerEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, planId, taskId, false);
            break block45;
            catch (Exception e) {
                block44: {
                    try {
                        log.error("Couldn't postprocess space export file", (Throwable)e);
                        if (modifiedExportFile == null) break block44;
                    }
                    catch (Throwable throwable) {
                        if (modifiedExportFile != null) {
                            try {
                                Files.deleteIfExists(modifiedExportFile);
                            }
                            catch (IOException e2) {
                                log.warn("Couldn't delete temp file", (Throwable)e2);
                            }
                        }
                        this.buildAndSaveTimerEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, planId, taskId, false);
                        throw throwable;
                    }
                    try {
                        Files.deleteIfExists(modifiedExportFile);
                    }
                    catch (IOException e3) {
                        log.warn("Couldn't delete temp file", (Throwable)e3);
                    }
                }
                this.buildAndSaveTimerEvent(success, this.instantSupplier.get().toEpochMilli() - startTime, spaceKey, planId, taskId, false);
            }
        }
    }

    @VisibleForTesting
    static boolean isGDPRReadyServer(String serverVersion) {
        return ConfluenceServerVersion.of(serverVersion).greaterOrEqual(GDPR_CONFLUENCE_VERSION);
    }

    private void addPropertyElement(XMLEventWriter writer, String propertyName, String cdata) throws XMLStreamException {
        QName propertyElementName = new QName("property");
        writer.add(this.eventFactory.createStartElement(propertyElementName, (Iterator<? extends Attribute>)Iterators.singletonIterator((Object)this.eventFactory.createAttribute("name", propertyName)), null));
        writer.add(this.eventFactory.createCData(cdata));
        writer.add(this.eventFactory.createEndElement(propertyElementName, null));
    }

    private EventProcessor processUserNameCData(boolean sawEmail, boolean sawFullName, ProcessingContext ctx) throws XMLStreamException {
        ctx.writer.add(ctx.event);
        if (ctx.event.isCharacters()) {
            return _ctx -> this.processUserProperty(ctx.event.asCharacters().getData(), sawEmail, sawFullName, (ProcessingContext)_ctx);
        }
        return _ctx -> this.processUserProperty(null, sawEmail, sawFullName, (ProcessingContext)_ctx);
    }

    private EventProcessor processUserProperty(String username, boolean sawEmail, boolean sawFullName, ProcessingContext ctx) throws XMLStreamException {
        ctx.writer.add(ctx.event);
        if (ctx.event.isStartElement()) {
            StartElement element = ctx.event.asStartElement();
            if (XMLEventUtil.hasAttribute(element, "name", "email")) {
                return _ctx -> this.processUserObject(username, true, sawFullName, (ProcessingContext)_ctx);
            }
            if (XMLEventUtil.hasAttribute(element, "name", "fullName")) {
                return _ctx -> this.processUserObject(username, sawEmail, true, (ProcessingContext)_ctx);
            }
            if (XMLEventUtil.hasAttribute(element, "name", "name")) {
                return _ctx -> this.processUserNameCData(sawEmail, sawFullName, (ProcessingContext)_ctx);
            }
        } else if (ctx.event.isEndElement() && XMLEventUtil.hasLocalName(ctx.event.asEndElement(), "property")) {
            return _ctx -> this.processUserObject(username, sawEmail, sawFullName, (ProcessingContext)_ctx);
        }
        return _ctx -> this.processUserProperty(username, sawEmail, sawFullName, (ProcessingContext)_ctx);
    }

    private EventProcessor processUserObject(String username, boolean sawEmail, boolean sawFullName, ProcessingContext ctx) throws XMLStreamException {
        if (ctx.event.isStartElement() && XMLEventUtil.hasLocalName(ctx.event.asStartElement(), "property")) {
            return this.processUserProperty(username, sawEmail, sawFullName, ctx);
        }
        if (ctx.event.isEndElement() && XMLEventUtil.hasLocalName(ctx.event.asEndElement(), "object")) {
            MigrationUser userInfo = ctx.usernamesToUsers.get(username);
            if (!sawEmail) {
                this.addPropertyElement(ctx.writer, "email", userInfo == null ? "" : userInfo.getEmail());
            }
            if (!sawFullName && userInfo != null && StringUtils.isNotBlank((CharSequence)userInfo.getFullName())) {
                this.addPropertyElement(ctx.writer, "fullName", userInfo.getFullName());
            }
            ctx.writer.add(ctx.event);
            return this::processUntilUserObject;
        }
        ctx.writer.add(ctx.event);
        return _ctx -> this.processUserObject(username, sawEmail, sawFullName, (ProcessingContext)_ctx);
    }

    private EventProcessor processUntilUserObject(ProcessingContext ctx) throws XMLStreamException {
        StartElement element;
        if (ctx.event.isStartElement() && XMLEventUtil.hasLocalName(element = ctx.event.asStartElement(), "object") && XMLEventUtil.hasAttribute(element, "class", "ConfluenceUserImpl")) {
            return this.processUserObject(null, false, false, ctx);
        }
        ctx.writer.add(ctx.event);
        return this::processUntilUserObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postprocessEntities(InputStream in, OutputStream out) throws Exception {
        XMLEventReader eventReader = null;
        XMLEventWriter eventWriter = null;
        try {
            eventReader = this.inputFactory.createXMLEventReader(in);
            eventWriter = this.outputFactory.createXMLEventWriter(out);
            Map<String, MigrationUser> usernamesToUsers = this.userService.getAllUsers().stream().collect(Collectors.toMap(MigrationUser::getUsername, Function.identity()));
            EventProcessor currentProcessor = this::processUntilUserObject;
            while (eventReader.hasNext()) {
                currentProcessor = (EventProcessor)currentProcessor.apply(new ProcessingContext(eventReader.nextEvent(), eventWriter, usernamesToUsers));
            }
        }
        finally {
            if (eventReader != null) {
                PostprocessingIOUtil.runQuietly(eventReader::close);
            }
            if (eventWriter != null) {
                PostprocessingIOUtil.runQuietly(eventWriter::close);
            }
        }
    }

    private void postprocessDescriptor(InputStream inputStream, ZipOutputStream out, boolean usersCreatedInUMS) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        String migrationProperties = "\ncmac=" + this.pluginVersionManager.getPluginVersion() + "\n";
        out.write(migrationProperties.getBytes(StandardCharsets.ISO_8859_1));
    }

    private void buildAndSaveTimerEvent(boolean success, long timeTaken, String spaceKey, String planId, String taskId, boolean isGDPRReadyServer) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildExportPostProcessedTimerEvent(success, timeTaken, spaceKey, planId, taskId, isGDPRReadyServer));
    }

    private static final class ProcessingContext {
        final XMLEvent event;
        final XMLEventWriter writer;
        final Map<String, MigrationUser> usernamesToUsers;

        ProcessingContext(XMLEvent event, XMLEventWriter writer, Map<String, MigrationUser> users) {
            this.event = event;
            this.writer = writer;
            this.usernamesToUsers = users;
        }
    }

    private static interface EventProcessor
    extends CheckedFunction<ProcessingContext, EventProcessor> {
    }
}

