/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.GlobalEntityType;
import com.atlassian.migration.agent.entity.MigrateGlobalEntitiesTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.newexport.CSVExportTaskContext;
import com.atlassian.migration.agent.newexport.DescriptorBuilder;
import com.atlassian.migration.agent.newexport.Queries;
import com.atlassian.migration.agent.newexport.RapidExporter;
import com.atlassian.migration.agent.newexport.TemplatedQueries;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.migration.agent.newexport.util.FileUtil;
import com.atlassian.migration.agent.service.NonSpaceTemplateConflictsInfo;
import com.atlassian.migration.agent.service.UserMappingsManager;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.confluence.ConfluenceCloudService;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.atlassian.migration.agent.store.TaskStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.file.AccessDeniedException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalEntitiesRapidExporter
extends RapidExporter<CSVExportTaskContext> {
    private static final Logger log = LoggerFactory.getLogger(GlobalEntitiesRapidExporter.class);
    private static final String ENTITY_NAME = "global_entities";
    private final TaskStore taskStore;
    private final ConfluenceCloudService confluenceCloudService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final Map<GlobalEntityType, TemplatedQueries> templateQueryMap = ImmutableMap.of((Object)((Object)GlobalEntityType.GLOBAL_SYSTEM_TEMPLATES), (Object)Queries.globalAndSystemTemplatesQuery, (Object)((Object)GlobalEntityType.GLOBAL_TEMPLATES), (Object)Queries.globalTemplatesQuery, (Object)((Object)GlobalEntityType.SYSTEM_TEMPLATES), (Object)Queries.systemTemplatesQuery);

    public GlobalEntitiesRapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, UserMappingsFileManager userMappingsFileManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, TaskStore taskStore, ConfluenceCloudService confluenceCloudService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        super(confluenceStore, descriptorBuilder, migrationAgentConfiguration, userMappingsFileManager, analyticsEventService, analyticsEventBuilder);
        this.taskStore = taskStore;
        this.confluenceCloudService = confluenceCloudService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @VisibleForTesting
    public GlobalEntitiesRapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, UserMappingsFileManager userMappingsFileManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, Supplier<Instant> instantSupplier, TaskStore taskStore, ConfluenceCloudService confluenceCloudService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        super(confluenceStore, descriptorBuilder, migrationAgentConfiguration, userMappingsFileManager, analyticsEventService, analyticsEventBuilder, instantSupplier);
        this.taskStore = taskStore;
        this.confluenceCloudService = confluenceCloudService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @Override
    protected void logResults(String tableName, CSVExportTaskContext taskContext, long totalTime) {
        log.info("Serialized results of query on table [{}] in [{} ms].", (Object)tableName, (Object)totalTime);
    }

    @Override
    public String export(CSVExportTaskContext taskContext) throws AccessDeniedException {
        String exportDir = FileUtil.createExportDirectory(taskContext.getTempDirFilePath());
        log.info("Starting CSV export of global templates to path: {}", (Object)exportDir);
        long startTime = ((Instant)this.instantSupplier.get()).toEpochMilli();
        HashSet<String> discoveredUserKeys = new HashSet<String>();
        log.info("Try to get user mappings from file for planId: {}", (Object)taskContext.getPlanId());
        Map<String, String> mappings = this.userMappingsFileManager.getUserMappingsFromFile(taskContext.getPlanId());
        UserMappingsManager userMappingsManager = new UserMappingsManager(this.migrationDarkFeaturesManager, mappings);
        this.runTemplateQuery(taskContext, exportDir, discoveredUserKeys);
        this.exportUserMappings(exportDir, discoveredUserKeys, taskContext, userMappingsManager);
        this.exportFileCount(exportDir, taskContext, ENTITY_NAME);
        this.descriptorBuilder.generateNonSpaceDescriptor(exportDir, taskContext.getTotalRowCount());
        log.info("Completed CSV export of global templates in {}ms", (Object)(((Instant)this.instantSupplier.get()).toEpochMilli() - startTime));
        log.info("Exported CSV files of global templates are located in directory {}", (Object)exportDir);
        return exportDir;
    }

    private void runTemplateQuery(CSVExportTaskContext taskContext, String exportDir, Set<String> discoveredUserKeys) {
        MigrateGlobalEntitiesTask migrateGlobalEntitiesTask = (MigrateGlobalEntitiesTask)this.taskStore.getTask(taskContext.getTaskId());
        NonSpaceTemplateConflictsInfo conflictsInfo = this.confluenceCloudService.getNonSpaceTemplateConflictsInfo(migrateGlobalEntitiesTask.getGlobalEntityType(), taskContext.getCloudId());
        List<String> conflictingTemplateIds = conflictsInfo.getConflicts().stream().map(conflict -> conflict.serverTemplateId).collect(Collectors.toList());
        String conflictingIdClauses = this.buildConflictingIdClauses(conflictingTemplateIds);
        this.buildAndSaveGlobalEntitiesConflictingStepEvent(conflictsInfo, taskContext.getPlanId(), taskContext.getTaskId());
        this.runQueries(this.templateQueryMap.get((Object)migrateGlobalEntitiesTask.getGlobalEntityType()).toQueries(this.getDbType(), conflictingIdClauses, conflictingIdClauses), this.createQueryRunner(Collections.emptyMap(), discoveredUserKeys), exportDir, taskContext);
    }

    private void buildAndSaveGlobalEntitiesConflictingStepEvent(NonSpaceTemplateConflictsInfo conflictsInfo, String planId, String taskId) {
        Plan plan = this.taskStore.getTask(taskId).getPlan();
        Long numOfSystemTemplatesMigrated = this.getNumOfTemplatesMigrated(conflictsInfo, GlobalEntityType.SYSTEM_TEMPLATES);
        Long numOfGlobalPageTemplatesMigrated = this.getNumOfTemplatesMigrated(conflictsInfo, GlobalEntityType.GLOBAL_TEMPLATES);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildGlobalEntitiesConflictingExportStepEvent(numOfGlobalPageTemplatesMigrated, numOfSystemTemplatesMigrated, planId, taskId, plan.getMigrationId()));
    }

    private String buildConflictingIdClauses(List<String> templateIds) {
        ArrayList<String> clauses = new ArrayList<String>();
        if (CollectionUtils.isEmpty(templateIds)) {
            clauses.add("1 = 1");
        } else {
            ArrayList templateKeyBatches = Lists.newArrayList((Iterable)Iterables.partition(templateIds, (int)1000));
            for (List templateKeyBatch : templateKeyBatches) {
                StringBuilder sb = new StringBuilder();
                for (String key : templateKeyBatch) {
                    sb.append(String.format("%s,", key));
                }
                sb.deleteCharAt(sb.length() - 1);
                clauses.add(String.format("TEMPLATEID NOT in (%s)", sb));
            }
        }
        return String.join((CharSequence)" and ", clauses);
    }

    @Override
    public void reportExportTablePerformance(CSVExportTaskContext taskContext, boolean success, String tableName, String query, String dbType, long totalTimeTaken, long timeToFirstRow, long rowsExported, long totalContentChars) {
        EventDto tableExportEvent = this.analyticsEventBuilder.buildGlobalEntitiesTableExportedToCSVTimerEvent(success, totalTimeTaken, taskContext.getPlanId(), taskContext.getCloudId(), taskContext.getTaskId(), tableName, query, dbType, timeToFirstRow, rowsExported, totalContentChars);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> tableExportEvent);
    }

    public long getNumOfTemplatesMigrated(NonSpaceTemplateConflictsInfo conflictsInfo, GlobalEntityType globalEntityType) {
        return conflictsInfo.getTotalNumOfServerTemplates(globalEntityType) - conflictsInfo.getTotalNumOfConflictingTemplates(globalEntityType);
    }
}

