/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.newexport.TemplatedQuery;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class GuardrailsQueries {
    private static final int DEFAULT_LIMIT = 100;
    public static final String SIZE_OF_DB_DEFAULT_QUERY = "SELECT pg_database.datname as database, cast(pg_database_size(pg_database.datname) as numeric)/1024/1024/1024 AS size FROM pg_database\n ORDER by size DESC";
    public static final String SIZE_OF_DB_ORACLE_QUERY = "select tablespace_name as database, sum(bytes)/1024/1024/1024 as size from dba_segments\n group by tablespace_name";
    public static final String SIZE_OF_DB_MSSQL_QUERY = "SELECT DB_NAME(database_id) AS \"database\", \n CAST(SUM(size) * 8 / 1024.0 / 1024.0 AS DECIMAL(18, 2)) AS \"size\" \n FROM sys.master_files \n GROUP BY \"database\" \n ORDER BY \"size\" DESC";
    public static final String SIZE_OF_DB_MYSQL_QUERY = "SELECT table_schema AS \"database\", round(SUM(data_length + index_length)/1024/1024/1024, 2) AS \"size\" \n FROM information_schema.TABLES\n GROUP BY \"database\" \n ORDER BY \"size\"";
    public static final String SIZE_OF_DB_H2_QUERY = "SELECT table_schema as database, ROW_COUNT_ESTIMATE as size \n FROM information_schema.TABLES \n  ORDER BY size DESC \n LIMIT 100";
    static final TemplatedQuery SIZE_OF_DB_QUERY = new TemplatedQuery("SELECT pg_database.datname as database, cast(pg_database_size(pg_database.datname) as numeric)/1024/1024/1024 AS size FROM pg_database\n ORDER by size DESC", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)"select tablespace_name as database, sum(bytes)/1024/1024/1024 as size from dba_segments\n group by tablespace_name", (Object)((Object)DbType.MSSQL), (Object)"SELECT DB_NAME(database_id) AS \"database\", \n CAST(SUM(size) * 8 / 1024.0 / 1024.0 AS DECIMAL(18, 2)) AS \"size\" \n FROM sys.master_files \n GROUP BY \"database\" \n ORDER BY \"size\" DESC", (Object)((Object)DbType.MYSQL), (Object)"SELECT table_schema AS \"database\", round(SUM(data_length + index_length)/1024/1024/1024, 2) AS \"size\" \n FROM information_schema.TABLES\n GROUP BY \"database\" \n ORDER BY \"size\"", (Object)((Object)DbType.H2), (Object)"SELECT table_schema as database, ROW_COUNT_ESTIMATE as size \n FROM information_schema.TABLES \n  ORDER BY size DESC \n LIMIT 100"));
    public static final String SIZE_OF_TABLES_DEFAULT_QUERY = String.format("SELECT cast(C.oid as varchar) as database, nspname || '.' || relname AS table, cast(pg_relation_size(C.oid) AS numeric)/1024/1024/1024 AS size \n FROM pg_class C\n LEFT JOIN pg_namespace N ON (N.oid = C.relnamespace) WHERE nspname NOT IN ('pg_catalog', 'information_schema')  ORDER BY pg_relation_size(C.oid) DESC LIMIT %d", 100);
    public static final String SIZE_OF_TABLES_ORACLE_QUERY = String.format("SELECT DS.TABLESPACE_NAME AS \"database\", SEGMENT_NAME AS \"table\", SUM(DS.BYTES)/1024/1024/1024 AS size\n  FROM DBA_SEGMENTS DS\n  WHERE SEGMENT_NAME IN (SELECT TABLE_NAME FROM DBA_TABLES)\n  GROUP BY DS.TABLESPACE_NAME,\n  SEGMENT_NAME\n  ORDER BY size DESC\n  FETCH FIRST %d ROWS ONLY", 100);
    public static final String SIZE_OF_TABLES_MSSQL_QUERY = String.format("SELECT TOP %d s.name as \"database\", t.NAME AS \"table\", CAST(SUM(a.total_pages) * 8 / 1024.0 / 1024.0 AS DECIMAL(10,2)) AS size \n  FROM sys.tables t \n  INNER JOIN sys.indexes i ON t.OBJECT_ID = i.object_id \n  INNER JOIN sys.partitions p ON i.object_id = p.OBJECT_ID AND i.index_id = p.index_id \n  INNER JOIN sys.allocation_units a ON p.partition_id = a.container_id \n  LEFT OUTER JOIN sys.schemas s ON t.schema_id = s.schema_id \n  WHERE t.NAME NOT LIKE 'dt%%' \n  AND t.is_ms_shipped = 0 \n  AND i.OBJECT_ID > 255 \n  GROUP BY t.Name, s.Name \n  ORDER BY size DESC", 100);
    public static final String SIZE_OF_TABLES_MYSQL_QUERY = String.format("SELECT \n  table_schema as \"database\", \n  table_name AS \"table\", \n  round(((data_length + index_length))/1024/1024/1024, 2) \"size\" \n FROM information_schema.TABLES \n ORDER BY (data_length + index_length) DESC LIMIT %d", 100);
    public static final String SIZE_OF_TABLES_H2_QUERY = String.format("SELECT table_schema as database, table_name as table, ROW_COUNT_ESTIMATE as size \n FROM information_schema.TABLES \n  ORDER BY ROW_COUNT_ESTIMATE DESC LIMIT %d", 100);
    static final TemplatedQuery SIZE_OF_TABLES_QUERY = new TemplatedQuery(SIZE_OF_TABLES_DEFAULT_QUERY, (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)SIZE_OF_TABLES_ORACLE_QUERY, (Object)((Object)DbType.MSSQL), (Object)SIZE_OF_TABLES_MSSQL_QUERY, (Object)((Object)DbType.MYSQL), (Object)SIZE_OF_TABLES_MYSQL_QUERY, (Object)((Object)DbType.H2), (Object)SIZE_OF_TABLES_H2_QUERY));
    public static final String PAGE_DEPTH_DEFAULT_QUERY = "with recursive query as  (select 0 as depth, contentid, spaceid  from CONTENT  where parentid is null  and contenttype in ('PAGE')  and content_status = 'current'  union select depth + 1, child.contentid, child.spaceid  from CONTENT child  inner join query on child.parentid = query.contentid)  select query.spaceid as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.spaceid = spaces.spaceid group by query.spaceid order by max_depth desc";
    public static final String PAGE_DEPTH_ORACLE_QUERY = "with query (depth,CONTENTID,SPACEID) as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID)  select query.SPACEID as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID group by query.SPACEID order by max_depth desc";
    public static final String PAGE_DEPTH_MSSQL_QUERY = "with query as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID)  select CAST(query.SPACEID AS BIGINT) AS \"space_id\", max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID  group by query.SPACEID order by max_depth desc";
    static final TemplatedQuery PAGE_DEPTH_QUERY = new TemplatedQuery("with recursive query as  (select 0 as depth, contentid, spaceid  from CONTENT  where parentid is null  and contenttype in ('PAGE')  and content_status = 'current'  union select depth + 1, child.contentid, child.spaceid  from CONTENT child  inner join query on child.parentid = query.contentid)  select query.spaceid as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.spaceid = spaces.spaceid group by query.spaceid order by max_depth desc", (Map<DbType, String>)ImmutableMap.of((Object)((Object)DbType.ORACLE), (Object)"with query (depth,CONTENTID,SPACEID) as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID)  select query.SPACEID as space_id, max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID group by query.SPACEID order by max_depth desc", (Object)((Object)DbType.MSSQL), (Object)"with query as  (select 0 as depth, CONTENTID, SPACEID  from CONTENT  where PARENTID is null  and CONTENTTYPE in ('PAGE')  and CONTENT_STATUS = 'current'  union all select depth + 1, child.CONTENTID, child.SPACEID  from CONTENT child  inner join query on child.PARENTID = query.CONTENTID)  select CAST(query.SPACEID AS BIGINT) AS \"space_id\", max(query.depth) as max_depth from query  inner join SPACES spaces on query.SPACEID = spaces.SPACEID  group by query.SPACEID order by max_depth desc", (Object)((Object)DbType.H2), (Object)""));

    private GuardrailsQueries() {
    }
}

