/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.dto;

import com.atlassian.migration.agent.dto.util.IncorrectConfigurationException;
import com.atlassian.migration.agent.entity.Config;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class ConfigDto {
    @JsonProperty
    private Integer exportConcurrencyClusterMax;
    @JsonProperty
    private Integer exportConcurrencyNodeMax;
    @JsonProperty
    private Integer attachmentConcurrencyClusterMax;
    @JsonProperty
    private Integer attachmentConcurrencyNodeMax;
    @JsonProperty
    private Integer importConcurrencyClusterMax;
    @JsonProperty
    private Integer importConcurrencyNodeMax;
    @JsonProperty
    private Integer uploadConcurrencyClusterMax;
    @JsonProperty
    private Integer uploadConcurrencyNodeMax;
    @JsonProperty
    private Integer attachmentUploadConcurrency;

    public ConfigDto(Config config) {
        this.exportConcurrencyClusterMax = config.getExportConcurrencyClusterMax();
        this.exportConcurrencyNodeMax = config.getExportConcurrencyNodeMax();
        this.attachmentConcurrencyClusterMax = config.getAttachmentConcurrencyClusterMax();
        this.attachmentConcurrencyNodeMax = config.getAttachmentConcurrencyNodeMax();
        this.importConcurrencyClusterMax = config.getImportConcurrencyClusterMax();
        this.importConcurrencyNodeMax = config.getImportConcurrencyNodeMax();
        this.uploadConcurrencyClusterMax = config.getUploadConcurrencyClusterMax();
        this.uploadConcurrencyNodeMax = config.getUploadConcurrencyNodeMax();
        this.attachmentUploadConcurrency = config.getAttachmentUploadConcurrency();
    }

    public void setExportConcurrencyClusterMax(@NotNull Integer exportConcurrencyClusterMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(exportConcurrencyClusterMax, "Export concurrency (cluster) must be greater than zero");
        this.exportConcurrencyClusterMax = exportConcurrencyClusterMax;
    }

    public void setExportConcurrencyNodeMax(@NotNull Integer exportConcurrencyNodeMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(exportConcurrencyNodeMax, "Export concurrency (Node) must be greater than zero");
        this.exportConcurrencyNodeMax = exportConcurrencyNodeMax;
    }

    public void setAttachmentConcurrencyClusterMax(@NotNull Integer attachmentConcurrencyClusterMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(attachmentConcurrencyClusterMax, "Attachment concurrency (cluster) must be greater than zero");
        this.attachmentConcurrencyClusterMax = attachmentConcurrencyClusterMax;
    }

    public void setAttachmentConcurrencyNodeMax(@NotNull Integer attachmentConcurrencyNodeMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(attachmentConcurrencyNodeMax, "Attachment concurrency (node) must be greater than zero");
        this.attachmentConcurrencyNodeMax = attachmentConcurrencyNodeMax;
    }

    public void setImportConcurrencyClusterMax(@NotNull Integer importConcurrencyClusterMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(importConcurrencyClusterMax, "Space import concurrency (cluster) must be greater than zero");
        this.importConcurrencyClusterMax = importConcurrencyClusterMax;
    }

    public void setImportConcurrencyNodeMax(@NotNull Integer importConcurrencyNodeMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(importConcurrencyNodeMax, "Space import concurrency (node) must be greater than zero");
        this.importConcurrencyNodeMax = importConcurrencyNodeMax;
    }

    public void setUploadConcurrencyClusterMax(@NotNull Integer uploadConcurrencyClusterMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(uploadConcurrencyClusterMax, "Space upload concurrency (cluster) must be greater than zero");
        this.uploadConcurrencyClusterMax = uploadConcurrencyClusterMax;
    }

    public void setUploadConcurrencyNodeMax(@NotNull Integer uploadConcurrencyNodeMax) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(uploadConcurrencyNodeMax, "Space upload concurrency (node) must be greater than zero");
        this.uploadConcurrencyNodeMax = uploadConcurrencyNodeMax;
    }

    public void setAttachmentUploadConcurrency(@NotNull Integer attachmentUploadConcurrency) throws IncorrectConfigurationException {
        ConfigDto.assertMinimumConcurrency(attachmentUploadConcurrency, "Attachment upload concurrency must be greater than zero");
        this.attachmentUploadConcurrency = attachmentUploadConcurrency;
    }

    private static void assertMinimumConcurrency(@NotNull Integer concurrency, @NotNull String errorMessage) throws IncorrectConfigurationException {
        if (concurrency <= 0) {
            throw new IncorrectConfigurationException(errorMessage);
        }
    }

    @Generated
    public Integer getExportConcurrencyClusterMax() {
        return this.exportConcurrencyClusterMax;
    }

    @Generated
    public Integer getExportConcurrencyNodeMax() {
        return this.exportConcurrencyNodeMax;
    }

    @Generated
    public Integer getAttachmentConcurrencyClusterMax() {
        return this.attachmentConcurrencyClusterMax;
    }

    @Generated
    public Integer getAttachmentConcurrencyNodeMax() {
        return this.attachmentConcurrencyNodeMax;
    }

    @Generated
    public Integer getImportConcurrencyClusterMax() {
        return this.importConcurrencyClusterMax;
    }

    @Generated
    public Integer getImportConcurrencyNodeMax() {
        return this.importConcurrencyNodeMax;
    }

    @Generated
    public Integer getUploadConcurrencyClusterMax() {
        return this.uploadConcurrencyClusterMax;
    }

    @Generated
    public Integer getUploadConcurrencyNodeMax() {
        return this.uploadConcurrencyNodeMax;
    }

    @Generated
    public Integer getAttachmentUploadConcurrency() {
        return this.attachmentUploadConcurrency;
    }

    @Generated
    public ConfigDto() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigDto)) {
            return false;
        }
        ConfigDto other = (ConfigDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$exportConcurrencyClusterMax = this.getExportConcurrencyClusterMax();
        Integer other$exportConcurrencyClusterMax = other.getExportConcurrencyClusterMax();
        if (this$exportConcurrencyClusterMax == null ? other$exportConcurrencyClusterMax != null : !((Object)this$exportConcurrencyClusterMax).equals(other$exportConcurrencyClusterMax)) {
            return false;
        }
        Integer this$exportConcurrencyNodeMax = this.getExportConcurrencyNodeMax();
        Integer other$exportConcurrencyNodeMax = other.getExportConcurrencyNodeMax();
        if (this$exportConcurrencyNodeMax == null ? other$exportConcurrencyNodeMax != null : !((Object)this$exportConcurrencyNodeMax).equals(other$exportConcurrencyNodeMax)) {
            return false;
        }
        Integer this$attachmentConcurrencyClusterMax = this.getAttachmentConcurrencyClusterMax();
        Integer other$attachmentConcurrencyClusterMax = other.getAttachmentConcurrencyClusterMax();
        if (this$attachmentConcurrencyClusterMax == null ? other$attachmentConcurrencyClusterMax != null : !((Object)this$attachmentConcurrencyClusterMax).equals(other$attachmentConcurrencyClusterMax)) {
            return false;
        }
        Integer this$attachmentConcurrencyNodeMax = this.getAttachmentConcurrencyNodeMax();
        Integer other$attachmentConcurrencyNodeMax = other.getAttachmentConcurrencyNodeMax();
        if (this$attachmentConcurrencyNodeMax == null ? other$attachmentConcurrencyNodeMax != null : !((Object)this$attachmentConcurrencyNodeMax).equals(other$attachmentConcurrencyNodeMax)) {
            return false;
        }
        Integer this$importConcurrencyClusterMax = this.getImportConcurrencyClusterMax();
        Integer other$importConcurrencyClusterMax = other.getImportConcurrencyClusterMax();
        if (this$importConcurrencyClusterMax == null ? other$importConcurrencyClusterMax != null : !((Object)this$importConcurrencyClusterMax).equals(other$importConcurrencyClusterMax)) {
            return false;
        }
        Integer this$importConcurrencyNodeMax = this.getImportConcurrencyNodeMax();
        Integer other$importConcurrencyNodeMax = other.getImportConcurrencyNodeMax();
        if (this$importConcurrencyNodeMax == null ? other$importConcurrencyNodeMax != null : !((Object)this$importConcurrencyNodeMax).equals(other$importConcurrencyNodeMax)) {
            return false;
        }
        Integer this$uploadConcurrencyClusterMax = this.getUploadConcurrencyClusterMax();
        Integer other$uploadConcurrencyClusterMax = other.getUploadConcurrencyClusterMax();
        if (this$uploadConcurrencyClusterMax == null ? other$uploadConcurrencyClusterMax != null : !((Object)this$uploadConcurrencyClusterMax).equals(other$uploadConcurrencyClusterMax)) {
            return false;
        }
        Integer this$uploadConcurrencyNodeMax = this.getUploadConcurrencyNodeMax();
        Integer other$uploadConcurrencyNodeMax = other.getUploadConcurrencyNodeMax();
        if (this$uploadConcurrencyNodeMax == null ? other$uploadConcurrencyNodeMax != null : !((Object)this$uploadConcurrencyNodeMax).equals(other$uploadConcurrencyNodeMax)) {
            return false;
        }
        Integer this$attachmentUploadConcurrency = this.getAttachmentUploadConcurrency();
        Integer other$attachmentUploadConcurrency = other.getAttachmentUploadConcurrency();
        return !(this$attachmentUploadConcurrency == null ? other$attachmentUploadConcurrency != null : !((Object)this$attachmentUploadConcurrency).equals(other$attachmentUploadConcurrency));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $exportConcurrencyClusterMax = this.getExportConcurrencyClusterMax();
        result = result * 59 + ($exportConcurrencyClusterMax == null ? 43 : ((Object)$exportConcurrencyClusterMax).hashCode());
        Integer $exportConcurrencyNodeMax = this.getExportConcurrencyNodeMax();
        result = result * 59 + ($exportConcurrencyNodeMax == null ? 43 : ((Object)$exportConcurrencyNodeMax).hashCode());
        Integer $attachmentConcurrencyClusterMax = this.getAttachmentConcurrencyClusterMax();
        result = result * 59 + ($attachmentConcurrencyClusterMax == null ? 43 : ((Object)$attachmentConcurrencyClusterMax).hashCode());
        Integer $attachmentConcurrencyNodeMax = this.getAttachmentConcurrencyNodeMax();
        result = result * 59 + ($attachmentConcurrencyNodeMax == null ? 43 : ((Object)$attachmentConcurrencyNodeMax).hashCode());
        Integer $importConcurrencyClusterMax = this.getImportConcurrencyClusterMax();
        result = result * 59 + ($importConcurrencyClusterMax == null ? 43 : ((Object)$importConcurrencyClusterMax).hashCode());
        Integer $importConcurrencyNodeMax = this.getImportConcurrencyNodeMax();
        result = result * 59 + ($importConcurrencyNodeMax == null ? 43 : ((Object)$importConcurrencyNodeMax).hashCode());
        Integer $uploadConcurrencyClusterMax = this.getUploadConcurrencyClusterMax();
        result = result * 59 + ($uploadConcurrencyClusterMax == null ? 43 : ((Object)$uploadConcurrencyClusterMax).hashCode());
        Integer $uploadConcurrencyNodeMax = this.getUploadConcurrencyNodeMax();
        result = result * 59 + ($uploadConcurrencyNodeMax == null ? 43 : ((Object)$uploadConcurrencyNodeMax).hashCode());
        Integer $attachmentUploadConcurrency = this.getAttachmentUploadConcurrency();
        result = result * 59 + ($attachmentUploadConcurrency == null ? 43 : ((Object)$attachmentUploadConcurrency).hashCode());
        return result;
    }
}

