/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/migration/app/FixedSizeOutputStream;", "Ljava/io/BufferedOutputStream;", "out", "Ljava/io/OutputStream;", "chunkSize", "", "(Ljava/io/OutputStream;I)V", "closed", "", "close", "", "flush", "flushIfFull", "remainingBufferBytes", "write", "bytes", "", "offset", "length", "b", "writeBlock", "app-migration-assistant"})
public final class FixedSizeOutputStream
extends BufferedOutputStream {
    private boolean closed;

    public FixedSizeOutputStream(@NotNull OutputStream out, int chunkSize) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super(out, chunkSize);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        int n = this.count;
        this.count = n + 1;
        this.buf[n] = (byte)b;
        this.flushIfFull();
    }

    @Override
    public synchronized void write(@NotNull byte[] bytes, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int workingOffset = offset;
        int workingLength = length;
        while (workingLength > 0) {
            int countToWrite = Math.min(workingLength, this.remainingBufferBytes());
            System.arraycopy(bytes, workingOffset, this.buf, this.count, countToWrite);
            workingLength -= countToWrite;
            workingOffset += countToWrite;
            this.count += countToWrite;
            this.flushIfFull();
        }
    }

    @Override
    public synchronized void write(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.write(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.count > 0) {
                    this.writeBlock();
                }
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    private final void flushIfFull() throws IOException {
        if (this.count == this.buf.length) {
            this.writeBlock();
        }
    }

    private final void writeBlock() throws IOException {
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    private final int remainingBufferBytes() {
        return this.buf.length - this.count;
    }
}

