/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.entity.GuardrailsResponse;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseType;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.JobWithStatus;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentResult;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class InstanceAssessmentService
implements JobRunner {
    private final List<AssessmentQuery<?>> queryList;
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentService.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.confluence.migration.guardrails.InstanceAssessmentService");
    private static final String SERVER_NODE = "serverNode";
    private static final String DEFAULT_NODE = "defaultClusterNode";
    private final SchedulerService schedulerService;
    private final Map<String, AssessmentQuery<?>> queryMap;
    private final GuardrailsResponseGroupStore guardRailsResponseGroupStore;
    private final GuardrailsResponseStore guardrailsResponseStore;
    private final ClusterInformationService clusterInformationService;
    private final PluginTransactionTemplate ptx;
    private Map<DbType, List<String>> queriesToSkipPerDBMap;
    private DialectResolver dialectResolver;

    public InstanceAssessmentService(List<AssessmentQuery<?>> queryList, SchedulerService schedulerService, GuardrailsResponseGroupStore guardRailsResponseGroupStore, GuardrailsResponseStore guardrailsResponseStore, ClusterInformationService clusterInformationService, PluginTransactionTemplate ptx, DialectResolver dialectResolver) {
        this.queryList = queryList;
        this.schedulerService = schedulerService;
        this.guardRailsResponseGroupStore = guardRailsResponseGroupStore;
        this.guardrailsResponseStore = guardrailsResponseStore;
        this.clusterInformationService = clusterInformationService;
        this.ptx = ptx;
        this.dialectResolver = dialectResolver;
        this.queryMap = new HashMap();
        this.queriesToSkipPerDBMap = new HashMap<DbType, List<String>>();
        this.populateQueryMap();
        this.populateQueriesToSkipPerDBMap();
    }

    private void populateQueryMap() {
        this.queryList.forEach(query -> this.queryMap.put(query.getQueryId(), (AssessmentQuery<?>)query));
    }

    private void populateQueriesToSkipPerDBMap() {
        List<String> queriesToSkipOnNonPostgres = Arrays.asList(QueryIds.LIST_OF_APPS_INSTALLED.name(), QueryIds.NUMBER_OF_MACROS_PER_PAGE.name(), QueryIds.NUMBER_OF_TABLES_PER_PAGE.name(), QueryIds.SIZE_OF_TABLES_PER_PAGE.name(), QueryIds.NUMBER_OF_MEDIA_PER_PAGE.name());
        ArrayList<String> oracleQueriesToSkip = new ArrayList<String>(queriesToSkipOnNonPostgres);
        oracleQueriesToSkip.add(QueryIds.EMBEDDED_ATT_PER_PAGE.name());
        ArrayList<String> mysqlQueriesToSkip = new ArrayList<String>(queriesToSkipOnNonPostgres);
        mysqlQueriesToSkip.add(QueryIds.PAGE_TREE_DEPTH.name());
        List<String> postgresQueriesToSkip = Collections.singletonList(QueryIds.NUMBER_OF_MACROS_PER_PAGE.name());
        this.queriesToSkipPerDBMap.put(DbType.POSTGRES, postgresQueriesToSkip);
        this.queriesToSkipPerDBMap.put(DbType.ORACLE, oracleQueriesToSkip);
        this.queriesToSkipPerDBMap.put(DbType.MYSQL, mysqlQueriesToSkip);
        this.queriesToSkipPerDBMap.put(DbType.MSSQL, queriesToSkipOnNonPostgres);
        this.queriesToSkipPerDBMap.put(DbType.H2, queriesToSkipOnNonPostgres);
    }

    public List<String> executeAllQueries() {
        return this.queryList.stream().map(this::executeQueryForL1).collect(Collectors.toList());
    }

    private String executeQueryForL1(AssessmentQuery<?> assessmentQuery) {
        L1AssessmentResult result = (L1AssessmentResult)assessmentQuery.execute();
        String queryId = assessmentQuery.getQueryId();
        return queryId + ":" + result.generateL1AssessmentData();
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        try {
            String jobId = request.getJobId().toString();
            String nodeId = this.getNodeId();
            GuardrailsResponseGroup responseGroup = new GuardrailsResponseGroup(jobId, nodeId);
            String responseGroupId = this.ptx.write(() -> this.guardRailsResponseGroupStore.createResponseGroup(responseGroup));
            log.info("Running job for jobId:{}", (Object)jobId);
            List queriesToSkip = this.queriesToSkipPerDBMap.getOrDefault((Object)this.dialectResolver.getDbType(), Collections.emptyList());
            this.queryList.forEach(query -> this.executeQueryAndSave((AssessmentQuery<?>)query, request.getJobId().toString(), responseGroupId, queriesToSkip));
            log.info("Running jobs completed for jobId:{}", (Object)request.getJobId());
            this.ptx.write(() -> this.guardRailsResponseGroupStore.updateResponseGroup(responseGroupId));
        }
        catch (Exception e) {
            log.error(String.format("Failed to run job - jobId:{} for nodeId:{} ", request.getJobId(), this.getNodeId()), (Throwable)e);
        }
        return JobRunnerResponse.success((String)"");
    }

    public void executeQueryAndSave(AssessmentQuery<?> query, String jobId, String responseGroupId, List<String> queriesToSkip) {
        Long start = System.currentTimeMillis();
        GuardrailsResponse guardrailsResponse = new GuardrailsResponse();
        guardrailsResponse.setResponseGroupId(responseGroupId);
        guardrailsResponse.setQueryId(query.getQueryId());
        guardrailsResponse.setGuardrailsResponseType(GuardrailsResponseType.L1);
        GuardrailsResponseGroup guardrailsResponseGroup = this.guardRailsResponseGroupStore.getResponseGroupByJobId(jobId);
        guardrailsResponse.setResponseGroup(guardrailsResponseGroup);
        if (queriesToSkip.contains(query.getQueryId())) {
            log.info("Skipping query with queryId:{}", (Object)query.getQueryId());
            guardrailsResponse.setQueryResponse("");
            guardrailsResponse.setSuccess(true);
            guardrailsResponse.setQueryStatus(InstanceAssessmentStatus.SKIPPED.toString());
        } else {
            L1AssessmentResult result = null;
            try {
                result = (L1AssessmentResult)query.execute();
                Long end = System.currentTimeMillis();
                log.info("Finished executing query with queryId:{} for jobID:{} in :{}ms", new Object[]{query.getQueryId(), jobId, end - start});
                guardrailsResponse.setQueryResponse(result.generateL1AssessmentData() != null ? result.generateL1AssessmentData() : "");
                guardrailsResponse.setSuccess(true);
            }
            catch (Exception e) {
                log.error("Error while executing query for queryID: " + query.getQueryId(), (Throwable)e);
                guardrailsResponse.setQueryResponse("");
                guardrailsResponse.setSuccess(false);
            }
            String queryStatus = InstanceAssessmentStatus.FAILED.toString();
            if (guardrailsResponse.isSuccess()) {
                queryStatus = InstanceAssessmentStatus.COMPLETE.toString();
            }
            guardrailsResponse.setQueryStatus(queryStatus);
        }
        this.ptx.write(() -> this.guardrailsResponseStore.createGuardrailsResponse(guardrailsResponse));
    }

    public JobWithStatus scheduleInstanceAssessment() throws SchedulerServiceException {
        Set<JobDetails> activeJobs = this.getActiveJobs();
        if (!activeJobs.isEmpty()) {
            JobDetails job = activeJobs.stream().findFirst().orElse(null);
            String jobId = job.getJobId().toString();
            Map map = job.getParameters();
            String nodeId = (String)map.get(SERVER_NODE);
            log.info("Job already running for nodeId: {} and jobId:{}", (Object)nodeId, (Object)jobId);
            return new JobWithStatus(jobId, InstanceAssessmentStatus.IN_PROGRESS, this.getJobProgress(jobId));
        }
        log.info("There are no active jobs");
        JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withParameters(Collections.singletonMap(SERVER_NODE, this.getNodeId())).withSchedule(Schedule.runOnce(null)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER));
        log.info("Job scheduled with id:{} for  nodeId:{}", (Object)jobId, (Object)this.getNodeId());
        return new JobWithStatus(jobId.toString(), InstanceAssessmentStatus.NEW, null);
    }

    public Set<JobDetails> getActiveJobs() {
        return this.schedulerService.getJobsByJobRunnerKey(RUNNER_KEY).stream().collect(Collectors.toSet());
    }

    private String getNodeId() {
        return Optional.ofNullable(this.clusterInformationService.getCurrentNodeId()).orElse(DEFAULT_NODE);
    }

    public long getJobProgress(String jobId) {
        log.info("Job running for jobId:{}", (Object)jobId);
        int numberOfQueries = this.queryList.size();
        Long completedQueries = this.guardrailsResponseStore.getNumberOfQueries(jobId);
        log.info("Queries :{} is :{}", (Object)completedQueries, (Object)numberOfQueries);
        long progress = numberOfQueries == 0 ? 0L : completedQueries * 100L / (long)numberOfQueries;
        log.info("Progress for jobId:{} is :{}", (Object)jobId, (Object)progress);
        return progress;
    }

    public JobWithStatus processJobProgress(String jobId) {
        try {
            Set<JobDetails> activeJobsDetails = this.getActiveJobs();
            Set activeJobs = activeJobsDetails.stream().map(JobDetails::getJobId).map(Object::toString).collect(Collectors.toSet());
            log.info("Current jobId is:{} and number of running jobs are :{}", (Object)jobId, (Object)activeJobs.size());
            if (activeJobs.contains(jobId)) {
                long progress = this.getJobProgress(jobId);
                return new JobWithStatus(jobId, InstanceAssessmentStatus.IN_PROGRESS, progress);
            }
            log.info("Job completed for jobId:{}", (Object)jobId);
            return new JobWithStatus(jobId, InstanceAssessmentStatus.COMPLETE, 100L);
        }
        catch (Exception e) {
            log.error("Failed to get progress for jobId:{} with exception:{}", (Object)jobId, (Object)e);
            return new JobWithStatus(jobId, InstanceAssessmentStatus.FAILED, null);
        }
    }

    public String executeQuery(String queryId) {
        return ((L1AssessmentResult)this.queryMap.get(queryId).execute()).generateL1AssessmentData();
    }

    public JobWithStatus activeAssessment() {
        try {
            Set<JobDetails> activeJobs = this.getActiveJobs();
            if (!activeJobs.isEmpty()) {
                log.info("Job already running");
                JobDetails job = activeJobs.stream().findFirst().orElse(null);
                assert (job != null);
                String jobId = job.getJobId().toString();
                return new JobWithStatus(jobId, InstanceAssessmentStatus.IN_PROGRESS, this.getJobProgress(jobId));
            }
            return this.guardrailsResponseStore.getLatestResponseGroup().map(responseGroup -> new JobWithStatus(responseGroup.getJobId(), InstanceAssessmentStatus.COMPLETE, 100L)).orElseGet(() -> new JobWithStatus(null, InstanceAssessmentStatus.NOT_STARTED, null));
        }
        catch (Exception e) {
            log.error("Failed to get active jobs with exception:{}", (Object)e.getMessage(), (Object)e);
            return new JobWithStatus(null, InstanceAssessmentStatus.FAILED, null);
        }
    }
}

