/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.InvalidEmailsConfigDto;
import com.atlassian.migration.agent.service.email.DuplicateEmailsFixResult;
import com.atlassian.migration.agent.service.email.EmailCheckType;
import com.atlassian.migration.agent.service.email.GlobalEmailFixesConfigService;
import com.atlassian.migration.agent.service.email.InvalidEmailsFixResult;
import com.atlassian.migration.agent.service.email.NewEmailSuggestingService;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class GlobalUnsupportedUserHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalUnsupportedUserHandler.class);
    private final GlobalEmailFixesConfigService fixesConfigService;
    private final NewEmailSuggestingService newEmailSuggestingService;

    public GlobalUnsupportedUserHandler(GlobalEmailFixesConfigService fixesConfigService, NewEmailSuggestingService newEmailSuggestingService) {
        this.fixesConfigService = fixesConfigService;
        this.newEmailSuggestingService = newEmailSuggestingService;
    }

    public InvalidEmailsFixResult applyInvalidEmailsStrategy(List<MigrationUser> invalidUsers, String cloudId) {
        InvalidEmailsConfigDto config = this.fixesConfigService.getInvalidEmailsConfig();
        switch (config.getActionOnMigration()) {
            case DO_NOTHING: {
                return new InvalidEmailsFixResult.Builder().invalidUsers(invalidUsers).build();
            }
            case TOMBSTONE_ALL: {
                return new InvalidEmailsFixResult.Builder().tombstoneUsers(invalidUsers).build();
            }
            case USE_NEW_EMAILS: {
                return new InvalidEmailsFixResult.Builder().newMailUsers(this.generateNewEmails(invalidUsers, EmailCheckType.INV, cloudId)).build();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)config.getActionOnMigration()));
    }

    public DuplicateEmailsFixResult applyDuplicateEmailsStrategy(List<MigrationUser> duplicateUsers, String cloudId) {
        DuplicateEmailsConfigDto config = this.fixesConfigService.getDuplicateEmailsConfig();
        switch (config.getActionOnMigration()) {
            case DO_NOTHING: {
                return new DuplicateEmailsFixResult.Builder().duplicateUsers(duplicateUsers).build();
            }
            case MERGE_ALL: {
                return new DuplicateEmailsFixResult.Builder().mergeUsers(duplicateUsers).build();
            }
            case USE_NEW_EMAILS: {
                return new DuplicateEmailsFixResult.Builder().newMailUsers(this.generateNewEmails(duplicateUsers, EmailCheckType.DUP, cloudId)).build();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)config.getActionOnMigration()));
    }

    private List<MigrationUser> generateNewEmails(List<MigrationUser> users, EmailCheckType type, String cloudId) {
        return users.stream().filter(user -> StringUtils.isNotBlank((CharSequence)user.getUserKey())).map(user -> new MigrationUser(user.getUserKey(), user.getUsername(), user.getFullName(), this.newEmailSuggestingService.suggest(user.getUserKey(), user.getUsername(), user.getFullName(), type, cloudId), user.isActive())).collect(Collectors.toList());
    }
}

