/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.RequestValidationException;
import com.atlassian.migration.agent.mapi.executor.CloudExecutorService;
import com.atlassian.migration.agent.mapi.external.model.JobValidationException;
import com.atlassian.migration.agent.mapi.external.model.PublicApiException;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.impl.InvalidPlanException;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.spi.container.ResourceFilters;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="public/v1/jobs")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MapiResource {
    private CloudExecutorService cloudExecutorService;
    private AnalyticsEventService analyticsEventService;
    private AnalyticsEventBuilder analyticsEventBuilder;
    private final Supplier<Instant> instantSupplier;

    public MapiResource(CloudExecutorService cloudExecutorService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        this.cloudExecutorService = cloudExecutorService;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.instantSupplier = Instant::now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{jobId}/attach")
    public Response createPlan(@PathParam(value="jobId") String jobId) {
        long startTime = this.instantSupplier.get().toEpochMilli();
        int statusCode = Response.Status.CREATED.getStatusCode();
        String errorReason = "";
        PlanDto planDto = null;
        try {
            planDto = this.cloudExecutorService.createPlan(jobId);
            Response response = Response.status((int)statusCode).entity((Object)planDto).build();
            return response;
        }
        catch (Exception ex) {
            Response response = this.createErrorResponse(ex);
            statusCode = response.getStatus();
            errorReason = ex.getMessage();
            Response response2 = response;
            return response2;
        }
        finally {
            this.sendMapiAttachJobAnalyticsEvents(jobId, planDto, statusCode, errorReason, this.instantSupplier.get().toEpochMilli() - startTime);
        }
    }

    private Response createErrorResponse(Exception ex) {
        if (ex instanceof InvalidPlanException || ex instanceof IllegalArgumentException || ex instanceof JobValidationException || ex instanceof RequestValidationException) {
            return this.buildResponse(Response.Status.BAD_REQUEST, "Invalid Request. Reason = " + ex.getMessage());
        }
        if (ex instanceof PublicApiException.DuplicateRequestException) {
            return this.buildResponse(Response.Status.CONFLICT, "Duplicate Request. Reason = " + ex.getMessage());
        }
        if (ex instanceof PublicApiException) {
            return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, "Internal Server Error. Reason = " + ex.getMessage());
        }
        return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, "Please check Confluence Logs to find the issue or contact support, if the issue persists.");
    }

    private Response buildResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).entity((Object)message).build();
    }

    private void sendMapiAttachJobAnalyticsEvents(String jobId, @Nullable PlanDto planDto, int statusCode, @Nullable String errorReason, long totalTime) {
        ImmutableList events = ImmutableList.of((Object)this.analyticsEventBuilder.buildMapiAttachJobOperationalEvent(jobId, Optional.ofNullable(planDto), statusCode, errorReason, totalTime), (Object)this.analyticsEventBuilder.buildMapiAttachJobTimerMetricEvent(statusCode, totalTime));
        this.analyticsEventService.sendAnalyticsEventsAsync(() -> MapiResource.lambda$sendMapiAttachJobAnalyticsEvents$0((List)events));
    }

    private static /* synthetic */ Collection lambda$sendMapiAttachJobAnalyticsEvents$0(List events) {
        return events;
    }
}

