/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.model.stats;

import com.atlassian.migration.agent.model.stats.AttachmentStats;
import java.sql.Timestamp;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ContentSummary {
    public static final ContentSummary ZERO = ContentSummary.builder().numberOfPages(0L).numberOfBlogs(0L).numberOfAttachments(0L).numberOfDrafts(0L).build();
    @JsonProperty
    private final Long numberOfPages;
    @JsonProperty
    private final Long numberOfBlogs;
    @JsonProperty
    private final Long numberOfDrafts;
    @JsonProperty
    private final Long numberOfAttachments;
    @JsonProperty
    private final Instant lastModified;
    @JsonProperty
    private final AttachmentStats attachments;

    @JsonCreator
    private ContentSummary(@JsonProperty(value="attachments") AttachmentStats attachments, @JsonProperty(value="numberOfPages") Long numberOfPages, @JsonProperty(value="numberOfBlogs") Long numberOfBlogs, @JsonProperty(value="numberOfDrafts") Long numberOfDrafts, @JsonProperty(value="numberOfAttachments") Long numberOfAttachments, @Nullable @JsonProperty(value="lastModified") Instant lastModified) {
        this.numberOfPages = numberOfPages;
        this.numberOfBlogs = numberOfBlogs;
        this.numberOfDrafts = numberOfDrafts;
        this.numberOfAttachments = numberOfAttachments;
        this.attachments = attachments;
        this.lastModified = lastModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Long getNumberOfPages() {
        return this.numberOfPages;
    }

    public Long getNumberOfBlogs() {
        return this.numberOfBlogs;
    }

    public Long getNumberOfDrafts() {
        return this.numberOfDrafts;
    }

    public Long getNumberOfAttachments() {
        return this.numberOfAttachments;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public AttachmentStats getAttachments() {
        return this.attachments;
    }

    public static final class Builder {
        private Long numberOfPages;
        private Long numberOfBlogs;
        private Long numberOfDrafts;
        private Long numberOfAttachments;
        private Instant lastModified;
        private AttachmentStats attachments = AttachmentStats.ZERO;

        private Builder() {
        }

        @Nonnull
        public Builder numberOfPages(Long numberOfPages) {
            this.numberOfPages = numberOfPages;
            return this;
        }

        @Nonnull
        public Builder numberOfBlogs(Long numberOfBlogs) {
            this.numberOfBlogs = numberOfBlogs;
            return this;
        }

        @Nonnull
        public Builder numberOfDrafts(Long numberOfDrafts) {
            this.numberOfDrafts = numberOfDrafts;
            return this;
        }

        @Nonnull
        public Builder numberOfAttachments(Long numberOfAttachments) {
            this.numberOfAttachments = numberOfAttachments;
            return this;
        }

        @Nonnull
        public Builder attachments(AttachmentStats attachments) {
            this.attachments = attachments;
            return this;
        }

        @NotNull
        public Builder lastModified(Timestamp lastModified) {
            if (lastModified != null) {
                this.lastModified = lastModified.toInstant();
            }
            return this;
        }

        public ContentSummary build() {
            return new ContentSummary(this.attachments, this.numberOfPages, this.numberOfBlogs, this.numberOfDrafts, this.numberOfAttachments, this.lastModified);
        }
    }
}

