/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.results.PageDepthQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;

public class PageDepthQuery
implements GrQuery<PageDepthQueryResult>,
L1AssessmentQuery<PageDepthQueryResult> {
    private static final int LIMIT = 100;
    private final EntityManagerTemplate tmpl;
    private final BootstrapManager bootstrapManager;
    protected static final String POSTGRESQL_NATIVE_QUERY = "with recursive query as  (select 0 as depth, contentid, spaceid  from content  where parentid is null  and contenttype in ('PAGE')  and content_status = 'current'  union select depth + 1, child.contentid, child.spaceid  from content child  inner join query on child.parentid = query.contentid)  select max(query.depth) as max, query.spaceid from query  inner join spaces on query.spaceid = spaces.spaceid group by query.spaceid order by max desc";

    public PageDepthQuery(EntityManagerTemplate tmpl, BootstrapManager bootstrapManager) {
        this.tmpl = tmpl;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public String getQueryId() {
        return QueryIds.PAGE_TREE_DEPTH.name();
    }

    @Override
    public PageDepthQueryResult execute() {
        String query = this.getPageDepthQueryForCurrentDb();
        List<Tuple> dbResult = null;
        if (query != null) {
            dbResult = this.tmpl.nativeQuery(Tuple.class, query).max(100).list();
        }
        return new PageDepthQueryResult(dbResult);
    }

    protected String getPageDepthQueryForCurrentDb() {
        ApplicationConfiguration appConfig = this.bootstrapManager.getApplicationConfig();
        String dialect = (String)appConfig.getProperty((Object)"hibernate.dialect");
        if (dialect != null && (dialect = dialect.toLowerCase()).contains("postgresql")) {
            return POSTGRESQL_NATIVE_QUERY;
        }
        return null;
    }
}

