/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;

public final class GuardrailsUtil {
    private static final DecimalFormat df = new DecimalFormat("0.00");

    private GuardrailsUtil() {
        throw new IllegalStateException("Utility Class");
    }

    public static String formatTuple(Tuple t, Class<?> ... args) {
        StringBuilder formattedData = new StringBuilder("{");
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i].equals(BigDecimal.class) ? GuardrailsUtil.formatDecimal((BigDecimal)t.get(i, args[i])) : t.get(i, args[i]);
            formattedData.append(i > 0 ? ": " : "").append(o);
        }
        return formattedData.append('}').toString();
    }

    public static String formatLong(long l) {
        return String.valueOf(l);
    }

    public static String formatDouble(double d) {
        return String.valueOf(df.format(d));
    }

    public static String formatDecimal(BigDecimal d) {
        return df.format(d);
    }

    public static String formatTupleList(List<Tuple> groups, Class<?> ... args) {
        return groups.stream().map(tuple -> GuardrailsUtil.formatTuple(tuple, args)).collect(Collectors.joining(","));
    }

    public static String formatTupleListToJson(List<Tuple> groups) {
        return "[" + groups.stream().map(GuardrailsUtil::formatTupleToJson).collect(Collectors.joining(",")) + "]";
    }

    public static String formatTupleToJson(Tuple t) {
        StringBuilder formattedData = new StringBuilder("{");
        for (TupleElement e : t.getElements()) {
            Object o = t.get(e);
            formattedData.append("\"").append(e.getAlias()).append("\": \"").append(o).append("\", ");
        }
        return formattedData.substring(0, formattedData.length() - 2) + "}";
    }

    public static Tuple getTuple(final List<?> values) {
        return new Tuple(){

            public <X> X get(TupleElement<X> tupleElement) {
                return null;
            }

            public <X> X get(String alias, Class<X> type) {
                return null;
            }

            public Object get(String alias) {
                return null;
            }

            public <X> X get(int i, Class<X> type) {
                return (X)values.get(i);
            }

            public Object get(int i) {
                return values.get(i);
            }

            public Object[] toArray() {
                return new Object[0];
            }

            public List<TupleElement<?>> getElements() {
                return Collections.emptyList();
            }
        };
    }
}

