/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.UserMappingsManager;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.impl.UserService;
import com.atlassian.migration.agent.service.stepexecutor.space.PostprocessingIOUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportMigrationUser;
import com.atlassian.migration.agent.service.stepexecutor.space.XMLEventUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.XMLHelper;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.jodah.failsafe.function.CheckedFunction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class AtlassianAccountPostProcessor {
    private static final Logger log = ContextLoggerFactory.getLogger(AtlassianAccountPostProcessor.class);
    private static final String ENTITIES_XML_ZIP_ENTRY_NAME = "entities.xml";
    private static final String CONFLUENCE_USER_IMPL_CLASS = "ConfluenceUserImpl";
    private static final String PROPERTY_TAG = "property";
    private static final String NAME = "name";
    private static final String OBJECT_TAG = "object";
    private static final String ATLASSIAN_ACCOUNT_ID = "atlassianAccountId";
    private static final String CLASS = "class";
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final UserMappingsFileManager userMappingsFileManager;
    private final UserService userService;
    private final XMLHelper xmlHelper;
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;

    public AtlassianAccountPostProcessor(MigrationDarkFeaturesManager migrationDarkFeaturesManager, UserMappingsFileManager userMappingsFileManager, UserService userService, XMLHelper xmlHelper) {
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.userMappingsFileManager = userMappingsFileManager;
        this.userService = userService;
        this.xmlHelper = xmlHelper;
        this.inputFactory = XMLInputFactory.newFactory();
        this.outputFactory = XMLOutputFactory.newFactory();
        this.eventFactory = XMLEventFactory.newFactory();
        this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postprocess(String planId, Path exportFile) {
        Map<String, SpaceExportMigrationUser> userMappings = this.getUserMappings(planId);
        if (userMappings.isEmpty()) return;
        Path modifiedExportFile = null;
        modifiedExportFile = Files.createTempFile(exportFile.getParent(), null, null, new FileAttribute[0]);
        try (ZipFile in = new ZipFile(exportFile.toFile());
             ZipOutputStream out = new ZipOutputStream(IOUtils.buffer((OutputStream)Files.newOutputStream(modifiedExportFile, new OpenOption[0])));){
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                this.postProcessZipEntry(in, out, entries, userMappings);
            }
        }
        Files.move(modifiedExportFile, exportFile, StandardCopyOption.REPLACE_EXISTING);
        if (modifiedExportFile == null) return;
        try {
            Files.deleteIfExists(modifiedExportFile);
            return;
        }
        catch (IOException e) {
            log.warn("Couldn't delete temp file", (Throwable)e);
        }
        return;
        catch (Exception e) {
            try {
                log.error("Couldn't postprocess space export file", (Throwable)e);
                if (modifiedExportFile == null) return;
            }
            catch (Throwable throwable) {
                if (modifiedExportFile == null) throw throwable;
                try {
                    Files.deleteIfExists(modifiedExportFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.warn("Couldn't delete temp file", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                Files.deleteIfExists(modifiedExportFile);
                return;
            }
            catch (IOException e3) {
                log.warn("Couldn't delete temp file", (Throwable)e3);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcessZipEntry(ZipFile in, ZipOutputStream out, Enumeration<? extends ZipEntry> entries, Map<String, SpaceExportMigrationUser> userMappings) throws Exception {
        InputStream entryInputStream;
        block3: {
            ZipEntry entry = entries.nextElement();
            out.putNextEntry(PostprocessingIOUtil.copyEntry(entry));
            entryInputStream = in.getInputStream(entry);
            try {
                if (ENTITIES_XML_ZIP_ENTRY_NAME.equals(entry.getName())) {
                    this.postprocessEntities(this.xmlHelper.getXmlInputStream(entryInputStream), out, userMappings);
                    break block3;
                }
                IOUtils.copy((InputStream)entryInputStream, (OutputStream)out);
            }
            catch (Throwable throwable) {
                PostprocessingIOUtil.runQuietly(entryInputStream::close);
                throw throwable;
            }
        }
        PostprocessingIOUtil.runQuietly(entryInputStream::close);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postprocessEntities(InputStream in, OutputStream out, Map<String, SpaceExportMigrationUser> userMappings) throws Exception {
        XMLEventReader eventReader = null;
        XMLEventWriter eventWriter = null;
        try {
            eventReader = this.inputFactory.createXMLEventReader(in);
            eventWriter = this.outputFactory.createXMLEventWriter(out);
            EventProcessor currentProcessor = this::processUntilUserObject;
            while (eventReader.hasNext()) {
                currentProcessor = (EventProcessor)currentProcessor.apply(new ProcessingContext(eventReader.nextEvent(), eventWriter, userMappings));
            }
        }
        finally {
            if (eventReader != null) {
                PostprocessingIOUtil.runQuietly(eventReader::close);
            }
            if (eventWriter != null) {
                PostprocessingIOUtil.runQuietly(eventWriter::close);
            }
        }
    }

    private EventProcessor processUntilUserObject(ProcessingContext processingContext) throws XMLStreamException {
        StartElement startElement;
        if (processingContext.event.isStartElement() && this.isStartElementAConfluenceUserObject(startElement = processingContext.event.asStartElement())) {
            return this.processUserObject(null, processingContext);
        }
        processingContext.writer.add(processingContext.event);
        return this::processUntilUserObject;
    }

    private boolean isStartElementAConfluenceUserObject(StartElement element) {
        return XMLEventUtil.hasLocalName(element, OBJECT_TAG) && XMLEventUtil.hasAttribute(element, CLASS, CONFLUENCE_USER_IMPL_CLASS);
    }

    private EventProcessor processUserObject(@Nullable String username, ProcessingContext processingContext) throws XMLStreamException {
        if (processingContext.event.isStartElement() && XMLEventUtil.hasLocalName(processingContext.event.asStartElement(), PROPERTY_TAG)) {
            return this.processUserProperty(username, processingContext);
        }
        if (processingContext.event.isEndElement() && XMLEventUtil.hasLocalName(processingContext.event.asEndElement(), OBJECT_TAG)) {
            SpaceExportMigrationUser userInfo = processingContext.usernamesToUsers.get(username);
            if (userInfo != null && StringUtils.isNotBlank((CharSequence)userInfo.aaid)) {
                this.addPropertyElement(processingContext.writer, ATLASSIAN_ACCOUNT_ID, userInfo.aaid);
            }
            processingContext.writer.add(processingContext.event);
            return this::processUntilUserObject;
        }
        processingContext.writer.add(processingContext.event);
        return context -> this.processUserObject(username, (ProcessingContext)context);
    }

    private void addPropertyElement(XMLEventWriter writer, String propertyName, String cdata) throws XMLStreamException {
        QName propertyElementName = new QName(PROPERTY_TAG);
        writer.add(this.eventFactory.createStartElement(propertyElementName, (Iterator<? extends Attribute>)Iterators.singletonIterator((Object)this.eventFactory.createAttribute(NAME, propertyName)), null));
        writer.add(this.eventFactory.createCData(cdata));
        writer.add(this.eventFactory.createEndElement(propertyElementName, null));
    }

    private EventProcessor processUserProperty(@Nullable String username, ProcessingContext processingContext) throws XMLStreamException {
        processingContext.writer.add(processingContext.event);
        if (processingContext.event.isStartElement()) {
            StartElement element = processingContext.event.asStartElement();
            if (XMLEventUtil.hasAttribute(element, NAME, NAME)) {
                return this::processUserNameCData;
            }
        } else if (this.isEndPropertyTag(processingContext)) {
            return context -> this.processUserObject(username, (ProcessingContext)context);
        }
        return context -> this.processUserProperty(username, (ProcessingContext)context);
    }

    private boolean isEndPropertyTag(ProcessingContext ctx) {
        return ctx.event.isEndElement() && XMLEventUtil.hasLocalName(ctx.event.asEndElement(), PROPERTY_TAG);
    }

    private EventProcessor processUserNameCData(ProcessingContext processingContext) throws XMLStreamException {
        processingContext.writer.add(processingContext.event);
        if (processingContext.event.isCharacters()) {
            return context -> this.processUserProperty(processingContext.event.asCharacters().getData(), (ProcessingContext)context);
        }
        return context -> this.processUserProperty(null, (ProcessingContext)context);
    }

    private Map<String, String> getUserMappingsFromFile(String planId) {
        return this.userMappingsFileManager.getUserMappingsFromFile(planId);
    }

    @VisibleForTesting
    Map<String, SpaceExportMigrationUser> getUserMappings(String planId) {
        List<MigrationUser> users = this.userService.getAllUsers();
        Map<String, String> mappings = this.getUserMappingsFromFile(planId);
        UserMappingsManager userMappingsManager = new UserMappingsManager(this.migrationDarkFeaturesManager, mappings);
        return users.stream().collect(Collectors.toMap(MigrationUser::getUsername, user -> new SpaceExportMigrationUser(user.getEmail(), user.getUsername(), userMappingsManager.getAaid(user.getUserKey(), user.getEmail(), ""))));
    }

    private static final class ProcessingContext {
        final XMLEvent event;
        final XMLEventWriter writer;
        final Map<String, SpaceExportMigrationUser> usernamesToUsers;

        ProcessingContext(XMLEvent event, XMLEventWriter writer, Map<String, SpaceExportMigrationUser> usernamesToUsers) {
            this.event = event;
            this.writer = writer;
            this.usernamesToUsers = usernamesToUsers;
        }
    }

    private static interface EventProcessor
    extends CheckedFunction<ProcessingContext, EventProcessor> {
    }
}

