/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.AttachmentMigration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import com.atlassian.migration.agent.service.SpaceAttachments;
import com.atlassian.migration.agent.store.AttachmentMigrationStore;
import com.atlassian.migration.agent.store.AttachmentStore;
import com.atlassian.migration.agent.store.jpa.Page;
import com.atlassian.migration.agent.store.jpa.impl.StatelessResults;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttachmentService
implements AttachmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAttachmentService.class);
    private final PluginTransactionTemplate ptx;
    private final AttachmentMigrationStore attachmentMigrationStore;
    private final AttachmentStore attachmentStore;
    private final AttachmentManager attachmentManager;
    private final TransactionTemplate tx;
    private final MigrationAgentConfiguration migrationAgentConfiguration;

    public DefaultAttachmentService(PluginTransactionTemplate ptx, AttachmentMigrationStore attachmentMigrationStore, AttachmentStore attachmentStore, AttachmentManager attachmentManager, TransactionTemplate tx, MigrationAgentConfiguration migrationAgentConfiguration) {
        this.ptx = ptx;
        this.attachmentMigrationStore = attachmentMigrationStore;
        this.attachmentStore = attachmentStore;
        this.attachmentManager = attachmentManager;
        this.tx = tx;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
    }

    @Override
    public SpaceAttachments getAttachmentsToMigrate(String spaceKey, CloudSite cloudSite) {
        String cloudId = cloudSite.getCloudId();
        long attachmentsSizeToUpload = this.getAttachmentsToMigrateSize(cloudId, spaceKey);
        log.info("For space {} migrationSize to upload {}", (Object)spaceKey, (Object)attachmentsSizeToUpload);
        return new SpaceAttachments(this.listAttachmentsToMigrate(cloudId, spaceKey), attachmentsSizeToUpload);
    }

    @Override
    public void logSuccessfulAttachmentMigration(CloudSite cloudSite, com.atlassian.migration.agent.entity.Attachment attachment, String mediaId) {
        this.ptx.write(() -> this.updateAttachmentMigration(cloudSite.getCloudId(), attachment.getId(), mediaId, attachment.getVersion()));
    }

    @Override
    public void logFailedAttachmentMigration(CloudSite cloudSite, com.atlassian.migration.agent.entity.Attachment attachment) {
        log.warn("Failed attachment migration for attachment {} to cloud {}", (Object)attachment.getId(), (Object)cloudSite.getCloudId());
        this.ptx.write(() -> this.updateAttachmentMigration(cloudSite.getCloudId(), attachment.getId(), null, attachment.getVersion()));
    }

    public void updateAttachmentMigration(String cloudId, long attachmentId, String mediaId, int attachmentVersion) {
        Optional<AttachmentMigration> attachmentMigrations = this.attachmentMigrationStore.findMigration(attachmentId, cloudId);
        if (!attachmentMigrations.isPresent() || attachmentMigrations.get().getMediaId() == null || mediaId != null) {
            AttachmentMigration attachmentMigration = attachmentMigrations.isPresent() ? attachmentMigrations.get() : new AttachmentMigration();
            attachmentMigration.setCloudId(cloudId);
            attachmentMigration.setAttachmentId(attachmentId);
            attachmentMigration.setMediaId(mediaId);
            attachmentMigration.setVersion(attachmentVersion);
            this.attachmentMigrationStore.saveMigration(attachmentMigration);
        }
    }

    @Override
    public int deleteAttachmentMigrationTrackingByCloudSite(CloudSite cloudSite) {
        return this.ptx.write(() -> this.attachmentMigrationStore.deleteMigrationsByCloudId(cloudSite.getCloudId()));
    }

    @Override
    public void prepareMigratedAttachmentsForExport(String spaceKey, String cloudId) {
        this.paginateOverMigratedAttachments(spaceKey, cloudId, this.migrationAgentConfiguration.getAttachmentPrepareBatchSize(), (attachment, migData) -> attachment.setFileStoreId(migData.getMediaId()));
    }

    @Override
    public void cleanMigratedAttachmentsAfterExport(String spaceKey, String cloudId) {
        this.paginateOverMigratedAttachments(spaceKey, cloudId, this.migrationAgentConfiguration.getAttachmentPrepareBatchSize(), (attachment, migData) -> attachment.getProperties().removeProperty("FILESTORE_ID"));
    }

    @Override
    public SpaceAttachmentCount getAttachmentsCountInSpaceAndMigrated(String spaceKey, String cloudId, long spaceAttachmentCount) {
        return this.ptx.read(() -> {
            long migAttachmentCount = this.attachmentMigrationStore.countRetrievedAttachmentMigrationsBySpaceKeyAndCloudId(spaceKey, cloudId);
            long unRetrievableAttachmentCount = this.attachmentMigrationStore.countUnRetrievableAttachmentMigrationsBySpaceKeyAndCloudId(spaceKey, cloudId);
            return new SpaceAttachmentCount(cloudId, spaceKey, spaceAttachmentCount, migAttachmentCount, unRetrievableAttachmentCount);
        });
    }

    @Override
    public long countAlreadyMigratedAttachmentsBySpaceKeyAndCloudId(String spaceKey, String cloudId) {
        return this.ptx.read(() -> this.attachmentMigrationStore.countAlreadyMigratedAttachmentsBySpaceKeyAndCloudId(spaceKey, cloudId));
    }

    @Override
    public long countAttachmentsInSpace(String spaceKey) {
        return this.ptx.read(() -> this.attachmentStore.countAttachmentsBySpaceKey(spaceKey));
    }

    private void paginateOverMigratedAttachments(String spaceKey, String cloudId, int pageSize, BiConsumer<Attachment, AttachmentMigration> attachmentConsumer) {
        this.tx.execute(() -> {
            this.ptx.write(() -> {
                Page<AttachmentMigration> page = this.attachmentMigrationStore.listMigrations(cloudId, spaceKey, pageSize);
                while (page.hasContent()) {
                    Map migDataByAttachmentId = page.getContent().stream().collect(Collectors.toMap(AttachmentMigration::getAttachmentId, Function.identity()));
                    this.attachmentManager.getAttachments((List)ImmutableList.copyOf(migDataByAttachmentId.keySet())).forEach(attachment -> attachmentConsumer.accept((Attachment)attachment, (AttachmentMigration)migDataByAttachmentId.get(attachment.getId())));
                    page = page.next();
                }
            });
            return true;
        });
    }

    private StatelessResults<com.atlassian.migration.agent.entity.Attachment> listAttachmentsToMigrate(String cloudId, String spaceKey) {
        return this.ptx.read(() -> this.attachmentStore.getAttachmentsToMigrate(cloudId, spaceKey));
    }

    private long getAttachmentsToMigrateSize(String cloudId, String spaceKey) {
        return this.ptx.read(() -> this.attachmentStore.getAttachmentsToMigrateSize(cloudId, spaceKey));
    }
}

