/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.DefaultTypeSettings;
import com.atlassian.migration.agent.service.impl.MigrationSettingsType;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.codehaus.jackson.type.TypeReference;

public class ConcurrencySettingsService
extends DefaultTypeSettings {
    private static final TypeReference<Map<String, Integer>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Integer>>(){};
    private static final String SPACE_USERS_CONCURRENCY_MAX = "SPACE_USERS_CONCURRENCY_MAX";
    private static final String SPACE_USERS_CONCURRENCY_NODE_MAX = "SPACE_USERS_CONCURRENCY_NODE_MAX";

    public ConcurrencySettingsService(PluginSettingsFactory pluginSettingsFactory, MigrationAgentConfiguration migrationAgentConfiguration) {
        super(pluginSettingsFactory, migrationAgentConfiguration, MigrationSettingsType.CONCURRENCY);
    }

    @Override
    public Map<String, Integer> getSettings() {
        return (Map)super.getSettings();
    }

    @Override
    protected boolean isValidSettings(Object settingsObj) {
        return settingsObj != null;
    }

    @Override
    public Object mapStringToObject(String cloudTypeMap) {
        return Jsons.readValue(cloudTypeMap, MAP_TYPE_REFERENCE);
    }

    @Override
    protected Object getDefaultPluginSettings() {
        return ImmutableMap.of((Object)SPACE_USERS_CONCURRENCY_MAX, (Object)2, (Object)SPACE_USERS_CONCURRENCY_NODE_MAX, (Object)2);
    }

    public int getSpaceUsersMigrationExecutorConcurrencyClusterMax() {
        return (Integer)this.getSettings().get(SPACE_USERS_CONCURRENCY_MAX);
    }

    public int getSpaceUsersMigrationConcurrencyNodeMax() {
        return (Integer)this.getSettings().get(SPACE_USERS_CONCURRENCY_NODE_MAX);
    }
}

