/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.fx3.Fx3Client;
import com.atlassian.fx3.evaluation.ErrorKind;
import com.atlassian.fx3.evaluation.EvaluationReason;
import com.atlassian.fx3.evaluation.FeatureFlagKey;
import com.atlassian.fx3.evaluation.FeatureFlagValue;
import com.atlassian.migration.agent.service.featureflag.Fx3ClientHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlagClient {
    private Fx3Client fx3Client = null;
    private static final Logger log = LoggerFactory.getLogger(FeatureFlagClient.class);
    private static final EvaluationReason.Error FLAG_NOT_FOUND = new EvaluationReason.Error(ErrorKind.FLAG_NOT_FOUND);

    public FeatureFlagClient(Fx3ClientHandler fx3ClientHandler) {
        try {
            this.fx3Client = fx3ClientHandler.getFx3Client();
        }
        catch (Exception e) {
            log.error("Error occurred while initializing FeatureFlagClient with message : {}", (Object)e.getMessage());
        }
    }

    public void updateCloudId(String cloudId) {
        try {
            this.fx3Client.updateUserIdentifier(cloudId);
            this.fx3Client.performManualFetch();
        }
        catch (Exception e) {
            log.error("Error occurred while updating cloud id with message : {}", (Object)e.getMessage());
        }
    }

    public boolean isFeatureEnabled(String flagKey) {
        try {
            return this.fx3Client.getAllEnabledFlagsForUser().contains(flagKey);
        }
        catch (Exception e) {
            log.error("Error occurred while checking feature flag with message : {}", (Object)e.getMessage());
            return false;
        }
    }

    public <T> T getFeatureFlagValue(FeatureFlagKey<T> key, T defaultValue) {
        try {
            FeatureFlagValue result = this.fx3Client.getFlag(key);
            if (result.getEvaluationReason().equals(FLAG_NOT_FOUND)) {
                return defaultValue;
            }
            return (T)Optional.ofNullable(result.getValue()).orElse(defaultValue);
        }
        catch (Exception e) {
            log.error("Error occurred while checking feature flag {} with message : {}", (Object)key.getIdentifier(), (Object)e.getMessage());
            return defaultValue;
        }
    }

    List<String> getAllEnabledFeatureFlags() {
        try {
            Set result = this.fx3Client.getAllEnabledFlagsForUser();
            return new ArrayList<String>(result);
        }
        catch (Exception e) {
            log.error("Error occurred while getting all enabled feature flags with message : {}", (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }
}

