/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.service.PlanService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class UDCEnablementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UDCEnablementService.class);
    private static final int UDC_MAXIMUM_USERS = 500;
    private static final int DISABLED_COHORT = -1;
    private static final int CHECK_TIME_INTERVAL_HOURS = 1;
    private static final String UDC_ELIGIBILITY_SCAN = "udcEligibilityScan";
    private final Supplier<PluginSettings> pluginSettingsSupplier;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final AnalyticsEventService analyticsEventService;
    private final ObjectProvider<AnalyticsEventBuilder> analyticsEventBuilder;
    private final ObjectProvider<PlanService> planService;
    private final Clock clock;
    private final ExecutorService executor;
    private Instant lastCheckTime = null;

    public Consumer<ServerStats> udcEnablementServerStatsConsumer() {
        try {
            return serverStats -> {
                Instant now = this.clock.instant();
                if (this.lastCheckTime == null || Duration.between(this.lastCheckTime, now).toHours() > 1L) {
                    this.lastCheckTime = now;
                    this.executor.submit(this.wrapWithAuthenticatedContext(() -> this.enableUDCIfEligible(serverStats.getInstanceStats().getNumberOfUsers())));
                }
            };
        }
        catch (Exception ex) {
            log.error("Could not create consumer for UDC eligibility check", (Throwable)ex);
            return serverStats -> {};
        }
    }

    public void enableUDCIfEligible(int usersCount) {
        try {
            log.info("Verifying if UDC functionality should be enabled");
            if (this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes() || this.getLastEligibilityCount().isPresent()) {
                return;
            }
            boolean planRunning = ((PlanService)this.planService.getIfAvailable()).hasPlans(ExecutionStatus.RUNNING);
            if (planRunning) {
                return;
            }
            int cohort = this.migrationDarkFeaturesManager.getGlobalEmailFixesUsersInstanceCohort(500);
            if (cohort != -1 && usersCount <= cohort) {
                this.migrationDarkFeaturesManager.enableGlobalEmailFixedFeature();
                log.info("UDC has been enabled for this instance");
                this.sendAnalytics(usersCount);
                this.updateLastEligibilityCount(cohort);
            }
        }
        catch (Exception ex) {
            log.error("Could not run UDC eligibility check", (Throwable)ex);
        }
    }

    private Runnable wrapWithAuthenticatedContext(Runnable task) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return () -> {
            try {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                task.run();
            }
            finally {
                AuthenticatedUserThreadLocal.reset();
            }
        };
    }

    private void updateLastEligibilityCount(int cohort) {
        this.pluginSettingsSupplier.get().put(this.getPluginKey(), (Object)String.valueOf(cohort));
    }

    @NotNull
    private Optional<Integer> getLastEligibilityCount() {
        return Optional.ofNullable((String)this.pluginSettingsSupplier.get().get(this.getPluginKey())).filter(StringUtils::isNotBlank).map(Integer::parseInt);
    }

    private void sendAnalytics(int totalUsersCount) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> ((AnalyticsEventBuilder)this.analyticsEventBuilder.getIfAvailable()).buildUDCAutomaticallyEnabled(500, totalUsersCount));
    }

    private String getPluginKey() {
        return this.migrationAgentConfiguration.getPluginKey() + ":" + UDC_ELIGIBILITY_SCAN;
    }

    @Generated
    public UDCEnablementService(Supplier<PluginSettings> pluginSettingsSupplier, MigrationAgentConfiguration migrationAgentConfiguration, MigrationDarkFeaturesManager migrationDarkFeaturesManager, AnalyticsEventService analyticsEventService, ObjectProvider<AnalyticsEventBuilder> analyticsEventBuilder, ObjectProvider<PlanService> planService, Clock clock, ExecutorService executor) {
        this.pluginSettingsSupplier = pluginSettingsSupplier;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.planService = planService;
        this.clock = clock;
        this.executor = executor;
    }
}

