/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.results.SizeOfDBQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;
import org.slf4j.Logger;

public class SizeOfDBQuery
implements GrQuery<SizeOfDBQueryResult>,
L1AssessmentQuery<SizeOfDBQueryResult> {
    private static final Logger log = ContextLoggerFactory.getLogger(SizeOfDBQuery.class);
    private final EntityManagerTemplate tmpl;
    private final BootstrapManager bootstrapManager;

    public SizeOfDBQuery(EntityManagerTemplate tmpl, BootstrapManager bootstrapManager) {
        this.tmpl = tmpl;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public String getQueryId() {
        return QueryIds.SIZE_OF_DB.name();
    }

    @Override
    public SizeOfDBQueryResult execute() {
        String query = this.getSizeOfDBQuery();
        List<Tuple> result = this.tmpl.nativeQuery(Tuple.class, query).list();
        return new SizeOfDBQueryResult(result);
    }

    String getSizeOfDBQuery() {
        try {
            ApplicationConfiguration applicationConfig = this.bootstrapManager.getApplicationConfig();
            String dialect = (String)applicationConfig.getProperty((Object)"hibernate.dialect");
            log.info("Resolved hibernate dialect: {}", (Object)dialect);
            if (dialect != null && dialect.toLowerCase().contains("postgresql")) {
                return "SELECT pg_database.datname as \"database_name\", cast(pg_database_size(pg_database.datname) as numeric)/1024/1024/1024 AS size_gb FROM pg_database\n ORDER by size_gb DESC";
            }
            if (dialect != null && dialect.toLowerCase().contains("oracle")) {
                return "select tablespace_name, sum(bytes)/1024/1024/1024 Size_GB from dba_segments\n group by tablespace_name";
            }
            if (dialect != null && dialect.toLowerCase().contains("h2")) {
                return "SELECT table_schema, ROW_COUNT_ESTIMATE \n FROM information_schema.TABLES \n  ORDER BY ROW_COUNT_ESTIMATE DESC \n LIMIT 100";
            }
        }
        catch (Exception e) {
            log.debug("{} query failed to retrieve dialect, exception {}", (Object)QueryIds.SIZE_OF_DB.name(), (Object)e);
        }
        return "SELECT table_schema AS \"Database\", round(SUM(data_length + index_length)/1024/1024/1024, 2) AS \"size_gb\" \n FROM information_schema.TABLES\n GROUP BY table_schema\n ORDER BY \"size_gb\"";
    }
}

