/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.email;

import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.ContextProviderUtil;
import com.atlassian.migration.agent.service.check.email.DuplicateEmailCheckContext;
import com.atlassian.migration.agent.service.extract.UserGroupExtractFacade;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DuplicateEmailCheckContextProvider
implements CheckContextProvider<DuplicateEmailCheckContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DuplicateEmailCheckContextProvider.class);
    private final UserGroupExtractFacade userGroupExtractFacade;
    private final Function<MigrationUser, EmailData> transformToEmailData = user -> new EmailData(user.getUsername(), user.getEmail());

    public DuplicateEmailCheckContextProvider(UserGroupExtractFacade userGroupExtractFacade) {
        this.userGroupExtractFacade = userGroupExtractFacade;
    }

    @Override
    public DuplicateEmailCheckContext apply(Map<String, Object> parameters) {
        String cloudId = ContextProviderUtil.getCloudId(parameters);
        if (!parameters.containsKey("spaceKeys")) {
            List<EmailData> emails = this.getAllEmailData();
            return new DuplicateEmailCheckContext(cloudId, emails);
        }
        String[] spaceKeys = ContextProviderUtil.getSpaceKeys(parameters);
        Set<String> userSet = this.userGroupExtractFacade.getUsersFromSpaces(Arrays.asList(spaceKeys));
        List<EmailData> emails = this.userGroupExtractFacade.getAllUsers().stream().filter(u -> userSet.contains(u.getUserKey())).map(this.transformToEmailData).collect(Collectors.toList());
        return new DuplicateEmailCheckContext(cloudId, emails);
    }

    private List<EmailData> getAllEmailData() {
        return this.userGroupExtractFacade.getAllUsers().stream().map(this.transformToEmailData).collect(Collectors.toList());
    }
}

