/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.execution.StepExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@ParametersAreNonnullByDefault
public abstract class ImportExecutor
implements QueueConsumer,
JobRunner,
StepExecutor {
    protected static final String CONF_TASK_ID_JOB_PARAM = "confTaskId";
    protected static final String STEP_ID_JOB_PARAM = "stepId";
    protected static final Duration POLLING_PERIOD = Duration.ofSeconds(5L);
    protected final ProgressTracker progressTracker;
    protected final StepStore stepStore;
    protected final SchedulerService schedulerService;
    protected final StepSchedulerService stepSchedulerService;
    protected final PluginTransactionTemplate ptx;
    protected final AnalyticsEventService analyticsEventService;
    protected final AnalyticsEventBuilder analyticsEventBuilder;
    protected final Supplier<Instant> instantSupplier;
    protected final MigrationAgentConfiguration migrationAgentConfiguration;

    protected ImportExecutor(ProgressTracker progressTracker, StepStore stepStore, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationAgentConfiguration migrationAgentConfiguration) {
        this(progressTracker, stepStore, stepSchedulerService, schedulerService, ptx, analyticsEventService, analyticsEventBuilder, Instant::now, migrationAgentConfiguration);
    }

    @VisibleForTesting
    protected ImportExecutor(ProgressTracker progressTracker, StepStore stepStore, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, Supplier<Instant> instantSupplier, MigrationAgentConfiguration migrationAgentConfiguration) {
        this.progressTracker = progressTracker;
        this.stepStore = stepStore;
        this.stepSchedulerService = stepSchedulerService;
        this.schedulerService = schedulerService;
        this.ptx = ptx;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.instantSupplier = instantSupplier;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(this.getJobRunnerKey(), (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(this.getJobRunnerKey());
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(this.getStepType().name()).withConcurrencyLevel(this.getImportExecutorConcurrencyNumber()).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, this.getStepType(), () -> this.scheduleStep(stepId, jobId));
    }

    @VisibleForTesting
    public Optional<StepResult> scheduleStep(String stepId, String jobId) {
        String importTaskId = this.initiateImport(stepId);
        ImmutableMap jobParams = ImmutableMap.of((Object)STEP_ID_JOB_PARAM, (Object)stepId, (Object)CONF_TASK_ID_JOB_PARAM, (Object)importTaskId);
        Schedule schedule = Schedule.forInterval((long)POLLING_PERIOD.toMillis(), (Date)new Date(System.currentTimeMillis() + 5000L));
        this.stepSchedulerService.scheduleStep(stepId, this.getJobRunnerKey(), JobId.of((String)jobId), this.getStepType(), (Map<String, Serializable>)jobParams, schedule);
        return Optional.empty();
    }

    protected long getStepTime(Step step) {
        Progress progress = step.getProgress();
        if (progress != null && progress.getStartTime().isPresent()) {
            return this.instantSupplier.get().toEpochMilli() - progress.getStartTime().get().toEpochMilli();
        }
        return -1L;
    }

    protected boolean stepIsInCompleteStatus(Step step) {
        return step.getProgress().getStatus().isCompleted();
    }

    @VisibleForTesting
    protected abstract JobRunnerKey getJobRunnerKey();

    @VisibleForTesting
    protected abstract int getImportExecutorConcurrencyNumber();

    @VisibleForTesting
    protected abstract String initiateImport(String var1);

    @VisibleForTesting
    protected abstract Optional<StepResult> doProgressCheck(Step var1, String var2);
}

