/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.SpaceStatistic;
import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.newexport.Query;
import com.atlassian.migration.agent.newexport.processor.SpaceStatisticCalculationProcessor;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.store.SpaceStatisticStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.config.JobId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceStatisticCalculationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceStatisticCalculationService.class);
    private final SpaceStatisticStore spaceStatisticStore;
    private final JdbcConfluenceStore confluenceStore;
    private final EntityManagerTemplate entityManagerTemplate;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final ExecutorService executorService;
    private final String calculateSpaceStatisticWithoutHistoricalPages;
    private final String calculateSpaceStatisticIncludingHistoricalPages;
    private final PluginTransactionTemplate pluginTransactionTemplate;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final AnalyticsEventService analyticsEventService;
    private final Supplier<Instant> instantSupplier;
    @VisibleForTesting
    static final String CALCULATION_STEP = "calculation";
    @VisibleForTesting
    static final String STORAGE_STEP = "storage";
    @VisibleForTesting
    static final String JPQL_SPACE_ID_QUERY = "select s.id as id from Space s";
    @VisibleForTesting
    static final String JPQL_MISSING_SPACE_ID_QUERY = "select s.id as id from Space s left join SpaceStatistic st on s.id = st.spaceId where st.spaceId is null";
    private static final String FROM_CONTENT_TABLE_PLACE_HOLDER_NAME = "CONTENT_TABLE_PLACE_HOLDER";
    private static final String FROM_CONTENT_TABLE_INCLUDING_HISTORICAL_DATA_TEMPLATE = "from (\nselect CONTENTID, CONTENTTYPE, SPACEID, LASTMODDATE\n             from CONTENT\n             where SPACEID in\n                   (:spaceIds)\n             union\n             select historicalContent.contentId , historicalContent.contentType, historicalContent.spaceId, historicalContent.lastModDate\n             from (select a.CONTENTID as contentId, a.CONTENTTYPE as contentType, b.SPACEID as spaceId, a.LASTMODDATE as lastModDate\n                   from CONTENT a\n                   inner join CONTENT b on a.PREVVER = b.CONTENTID\n                   where a.PREVVER in (select CONTENTID\n                                       from CONTENT\n                                       where SPACEID in\n                                             (:spaceIds)\n                                         )\n                         and a.SPACEID is NULL\n                     ) historicalContent) c\n       group by c.SPACEID\n";
    private static final String FROM_CONTENT_TABLE_EXCLUDING_HISTORICAL_DATA_TEMPLATE = " from CONTENT c\n where c.SPACEID in (:spaceIds)\n group by c.SPACEID \n";
    private static final String CALCULATE_SPACE_STATISTICS_TEMPLATE = "select \n     sb.spaceId,\n     COALESCE(csq.sumOfPageBlogDraftCount, 0)  as sumOfPageBlogDraftCount,\n     COALESCE(csq.attachmentCount, 0)  as attachmentCount,\n     COALESCE(asq.attachmentSize, 0) as attachmentSize,\n     CASE\n          WHEN sb.lastUpdated is null then csq.lastUpdated\n          WHEN csq.lastUpdated is null then sb.lastUpdated\n          WHEN csq.lastUpdated > sb.lastUpdated then csq.lastUpdated\n          ELSE sb.lastUpdated\n       END as lastUpdated,\n     CURRENT_TIMESTAMP as lastCalculated\n from ( \n   select LASTMODDATE as lastUpdated, SPACEID as spaceId from SPACES where SPACEID in (:spaceIds)\n ) sb\n left join\n         (select SUM(CASE WHEN c.CONTENTTYPE in ('PAGE', 'BLOGPOST') THEN 1 ELSE 0 END) as sumOfPageBlogDraftCount,\n              SUM(CASE WHEN c.CONTENTTYPE = 'ATTACHMENT' THEN 1 ELSE 0 END)      as attachmentCount,\n              MAX(LASTMODDATE)                                                   as lastUpdated,\n              SPACEID                                                            as spaceId\nCONTENT_TABLE_PLACE_HOLDER ) csq  on csq.spaceId = sb.spaceId\n left join\n      (select SUM(cp.LONGVAL) as attachmentSize, c.SPACEID as spaceId\n          from CONTENT c\n                   join CONTENTPROPERTIES cp on c.CONTENTID = cp.CONTENTID\n          where cp.PROPERTYNAME = 'FILESIZE'\n            and c.CONTENTTYPE = 'ATTACHMENT'\n            and SPACEID in (:spaceIds)\n          group by c.SPACEID) asq on asq.spaceId = sb.spaceId";
    private String calculateSpaceStatisticWithHistoricalPagesUsingCTE = "with ContentBase as (select SPACEID, CONTENTID, LASTMODDATE, PREVVER, CONTENTTYPE\n              from CONTENT\n              where SPACEID in (:spaceIds)\n                and CONTENTTYPE in ('PAGE', 'BLOGPOST', 'ATTACHMENT', 'SPACEDESCRIPTION')),\n     SpacesBase as (select SPACEID, LASTMODDATE from SPACES where SPACEID in (:spaceIds)),\n     AllPageContent as (select SPACEID, CONTENTID, LASTMODDATE\n                        from ContentBase\n                        where CONTENTTYPE in ('PAGE', 'BLOGPOST')\n                        union\n                        select cb.SPACEID, c.CONTENTID, c.LASTMODDATE\n                        from CONTENT c\n                                 inner join ContentBase cb on cb.CONTENTID = c.PREVVER\n                                                      and c.SPACEID is null\n                                                     and c.PREVVER in (select CONTENTID from ContentBase where ContentBase.CONTENTTYPE in ('PAGE', 'BLOGPOST'))),\n     PageStat as (select count(*) as sumOfPageBlogDraftCount, SPACEID\n                  from AllPageContent\n                  group by SPACEID),\n     AttachmentStat as (select SUM(cp.LONGVAL) as attachmentSize, count(SPACEID) as attachmentCount, SPACEID\n                        from ContentBase cb\n                        join CONTENTPROPERTIES cp on cb.CONTENTID = cp.CONTENTID\n                        where cp.PROPERTYNAME = 'FILESIZE' and cb.CONTENTTYPE = 'ATTACHMENT'\n                        group by SPACEID),\n     RecentEdit as (select (CASE\n                                WHEN MAX(sb.LASTMODDATE) is null then MAX(cb.LASTMODDATE)\n                                WHEN MAX(cb.LASTMODDATE) is null then  MAX(sb.LASTMODDATE)\n                                WHEN  MAX(sb.LASTMODDATE) > MAX(cb.LASTMODDATE) then MAX(cb.LASTMODDATE)\n                                ELSE MAX(cb.LASTMODDATE)\n         END) as lastUpdated,\n                                  sb.SPACEID as SPACEID\n                           from ContentBase cb\n                           join SpacesBase sb on sb.SPACEID = cb.SPACEID\n                           group by sb.SPACEID)\nselect sb.SPACEID as spaceId, COALESCE(sumOfPageBlogDraftCount, 0) as sumOfPageBlogDraftCount, COALESCE(attachmentCount, 0) as attachmentCount, COALESCE(attachmentSize, 0) as attachmentSize, lastUpdated, CURRENT_TIMESTAMP as lastCalculated\nfrom SpacesBase sb\n         left join PageStat p on p.SPACEID = sb.SPACEID\n         left join AttachmentStat a on a.SPACEID = sb.SPACEID\n         left join RecentEdit r on r.SPACEID = sb.SPACEID";

    public SpaceStatisticCalculationService(SpaceStatisticStore spaceStatisticStore, JdbcConfluenceStore confluenceStore, EntityManagerTemplate entityManagerTemplate, PluginTransactionTemplate pluginTransactionTemplate, MigrationAgentConfiguration migrationAgentConfiguration, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService) {
        this(spaceStatisticStore, confluenceStore, entityManagerTemplate, pluginTransactionTemplate, migrationAgentConfiguration, Executors.newFixedThreadPool(2), analyticsEventBuilder, analyticsEventService, Instant::now);
    }

    @VisibleForTesting
    SpaceStatisticCalculationService(SpaceStatisticStore spaceStatisticStore, JdbcConfluenceStore confluenceStore, EntityManagerTemplate entityManagerTemplate, PluginTransactionTemplate pluginTransactionTemplate, MigrationAgentConfiguration migrationAgentConfiguration, ExecutorService executorService, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService, Supplier<Instant> instantSupplier) {
        this.spaceStatisticStore = spaceStatisticStore;
        this.confluenceStore = confluenceStore;
        this.entityManagerTemplate = entityManagerTemplate;
        this.pluginTransactionTemplate = pluginTransactionTemplate;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.executorService = executorService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.analyticsEventService = analyticsEventService;
        this.instantSupplier = instantSupplier;
        this.calculateSpaceStatisticWithoutHistoricalPages = this.buildQueryWithoutHistoricalData();
        this.calculateSpaceStatisticIncludingHistoricalPages = this.buildQueryIncludingHistoricalPages();
    }

    private String buildQueryWithoutHistoricalData() {
        return CALCULATE_SPACE_STATISTICS_TEMPLATE.replace(FROM_CONTENT_TABLE_PLACE_HOLDER_NAME, FROM_CONTENT_TABLE_EXCLUDING_HISTORICAL_DATA_TEMPLATE);
    }

    private String buildQueryIncludingHistoricalPages() {
        return this.migrationAgentConfiguration.getDBType().equals((Object)DbType.MYSQL) || this.migrationAgentConfiguration.getDBType().equals((Object)DbType.H2) ? CALCULATE_SPACE_STATISTICS_TEMPLATE.replace(FROM_CONTENT_TABLE_PLACE_HOLDER_NAME, FROM_CONTENT_TABLE_INCLUDING_HISTORICAL_DATA_TEMPLATE) : this.calculateSpaceStatisticWithHistoricalPagesUsingCTE;
    }

    @PreDestroy
    @VisibleForTesting
    void cleanup() {
        this.executorService.shutdown();
    }

    public void runSpaceStatisticCalculationIfEmptyOrMissingSpaces(JobId jobId, boolean awaitResult) {
        List<Long> spaceIds;
        List<Long> list = spaceIds = this.spaceStatisticStore.isSpaceStatisticEmpty() ? this.getSpaceIds() : this.getMissingSpaceIds();
        if (!spaceIds.isEmpty()) {
            log.info("Running {} spaces without space statistics", (Object)spaceIds.size());
            this.spinupJobsToRunSpaceStaticCalculations(jobId.toString(), true, spaceIds, awaitResult);
        } else {
            log.info("Skipped initial space statistic calculation.");
        }
    }

    public void runSpaceStatisticCalculationForSpaceIds(JobId jobId, boolean includeHistoricalData, List<Long> spaceIds, boolean awaitResult) {
        this.spinupJobsToRunSpaceStaticCalculations(jobId.toString(), includeHistoricalData, spaceIds, awaitResult);
    }

    public void runSpaceStatisticCalculation(JobId jobId, boolean includeHistoricalData, boolean awaitResult) {
        this.spinupJobsToRunSpaceStaticCalculations(jobId.toString(), includeHistoricalData, this.getSpaceIds(), awaitResult);
    }

    @VisibleForTesting
    void spinupJobsToRunSpaceStaticCalculations(String jobId, boolean includeHistoricalData, List<Long> spaceIds, boolean awaitResult) {
        long startTimeEpocMilli = this.instantSupplier.get().toEpochMilli();
        int batchLimit = this.migrationAgentConfiguration.getSpaceStatisticCalculationBatchLimit();
        List partitionedSpaceIds = Lists.partition(spaceIds, (int)batchLimit);
        String executionId = jobId + "-" + UUID.randomUUID();
        ArrayList results = new ArrayList();
        IntStream.range(0, partitionedSpaceIds.size()).boxed().collect(Collectors.toMap(index -> executionId + "-batch" + index, partitionedSpaceIds::get)).forEach((batchId, ids) -> results.add(this.executorService.submit(() -> this.calculateAndStore(jobId, executionId, (String)batchId, (List<Long>)ids, includeHistoricalData))));
        if (awaitResult) {
            long waitStartTimeEpocMilli = this.instantSupplier.get().toEpochMilli();
            results.forEach(future -> {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("Error while waiting for the future result of a batch ", (Throwable)e);
                }
            });
            long endTimeEpocMilli = this.instantSupplier.get().toEpochMilli();
            this.buildAndStoreExecutionCompletedEvent(jobId, executionId, partitionedSpaceIds.size(), batchLimit, spaceIds.size(), includeHistoricalData, startTimeEpocMilli, waitStartTimeEpocMilli, endTimeEpocMilli);
        }
    }

    @VisibleForTesting
    void calculateAndStore(String jobId, String executionId, String batchId, List<Long> spaceIds, boolean includeHistoricalData) {
        log.debug("Calculating space statistics for batch {} with {} spaces", (Object)batchId, (Object)spaceIds.size());
        long startTime = this.instantSupplier.get().toEpochMilli();
        CalculationResult calculationResult = this.calculateStatisticsFor(spaceIds, includeHistoricalData, batchId, executionId, jobId);
        long readEndTime = this.instantSupplier.get().toEpochMilli();
        StorageResult storageResult = this.storeStatistics(calculationResult.spaceStatistics, includeHistoricalData, batchId, executionId, jobId);
        long endTime = this.instantSupplier.get().toEpochMilli();
        log.info("Took {}ms to calculate and store space statistic for batch {} with {} spaces: {}ms to calculate and {}ms to store. ", new Object[]{endTime - startTime, batchId, spaceIds.size(), readEndTime - startTime, endTime - readEndTime});
        this.buildAndStoreBatchExecutionCompletedEvent(jobId, executionId, batchId, spaceIds.size(), includeHistoricalData, calculationResult, storageResult, startTime, readEndTime, endTime);
    }

    private StorageResult storeStatistics(List<SpaceStatistic> spaceStatistics, boolean includeHistoricalData, String batchId, String executionId, String jobId) {
        int analyticsBatchErrorLimit = this.migrationAgentConfiguration.getSpaceStatisticCalculationAnalyticsBatchErrorLimit();
        AtomicInteger upsertExceptionCount = new AtomicInteger();
        this.pluginTransactionTemplate.write(() -> spaceStatistics.forEach(spaceStatistic -> {
            block2: {
                try {
                    this.spaceStatisticStore.upsert((SpaceStatistic)spaceStatistic);
                }
                catch (Exception e) {
                    log.error("Failed to store statistic for spaceId {} of batch {} ", new Object[]{spaceStatistic.getSpaceId(), batchId, e});
                    upsertExceptionCount.getAndIncrement();
                    if (upsertExceptionCount.get() > analyticsBatchErrorLimit) break block2;
                    this.buildAndStoreBatchStepExecutionErrorEvent(jobId, executionId, batchId, STORAGE_STEP, spaceStatistics.size(), includeHistoricalData, e, String.valueOf(spaceStatistic.getSpaceId()));
                }
            }
        }));
        return new StorageResult(upsertExceptionCount.get() == 0, upsertExceptionCount.get());
    }

    private CalculationResult calculateStatisticsFor(List<Long> spaceIds, boolean includeHistoricalData, String batchId, String executionId, String jobId) {
        SpaceStatisticCalculationProcessor processor = this.newProcessor();
        try {
            this.confluenceStore.queryAndProcess(this.getSpaceStatisticCalculationQueryForSpaceIds(spaceIds, includeHistoricalData), Collections.emptyMap(), processor);
            return new CalculationResult(true, processor.getResult());
        }
        catch (Exception e) {
            log.error("Failed to Calculate statistics for batch {}.", (Object)batchId, (Object)e);
            this.buildAndStoreBatchStepExecutionErrorEvent(jobId, executionId, batchId, CALCULATION_STEP, spaceIds.size(), includeHistoricalData, e, null);
            return new CalculationResult(false, Collections.emptyList());
        }
    }

    @VisibleForTesting
    @NotNull
    Query getSpaceStatisticCalculationQueryForSpaceIds(List<Long> spaceIds, boolean includeHistoricalData) {
        String queryTemplate = includeHistoricalData ? this.calculateSpaceStatisticIncludingHistoricalPages : this.calculateSpaceStatisticWithoutHistoricalPages;
        return new Query(queryTemplate.replace(":spaceIds", spaceIds.stream().map(Object::toString).collect(Collectors.joining(","))));
    }

    @VisibleForTesting
    SpaceStatisticCalculationProcessor newProcessor() {
        return new SpaceStatisticCalculationProcessor();
    }

    private List<Long> getSpaceIds() {
        List<Long> spaceIds = this.entityManagerTemplate.query(Long.class, JPQL_SPACE_ID_QUERY).list();
        return spaceIds == null ? Collections.emptyList() : spaceIds;
    }

    private List<Long> getMissingSpaceIds() {
        List<Long> spaceIds = this.entityManagerTemplate.query(Long.class, JPQL_MISSING_SPACE_ID_QUERY).list();
        return spaceIds == null ? Collections.emptyList() : spaceIds;
    }

    private void buildAndStoreBatchStepExecutionErrorEvent(String jobId, String executionId, String batchId, String batchStep, int batchSize, boolean includeHistoricalData, Exception exception, String spaceId) {
        try {
            EventDto eventDto = this.analyticsEventBuilder.buildSpaceStatisticCalculationBatchStepExecutionErrorEvent(jobId, executionId, batchId, batchStep, batchSize, includeHistoricalData, exception, spaceId);
            this.analyticsEventService.saveAnalyticsEvent(eventDto);
        }
        catch (Exception e) {
            log.error("Failed to store analytics of the failure in {} for batchId {}", (Object)batchStep, (Object)batchId);
        }
    }

    private void buildAndStoreBatchExecutionCompletedEvent(String jobId, String executionId, String batchId, int batchSize, boolean includeHistoricalData, CalculationResult calculationResult, StorageResult storageResult, long startTimeEpochMilli, long readTimeEpochMilli, long endTimeEpochMilli) {
        try {
            EventDto eventDto = this.analyticsEventBuilder.buildSpaceStatisticCalculationBatchExecutionCompletedEvent(jobId, executionId, batchId, batchSize, includeHistoricalData, calculationResult.success && storageResult.success, (Map<String, Boolean>)ImmutableMap.of((Object)CALCULATION_STEP, (Object)calculationResult.success, (Object)STORAGE_STEP, (Object)storageResult.success), storageResult.errorCount + (calculationResult.success ? 0 : 1), startTimeEpochMilli, readTimeEpochMilli, endTimeEpochMilli);
            this.analyticsEventService.saveAnalyticsEvent(eventDto);
        }
        catch (Exception exception) {
            log.error("Failed to store analytics for batchId {}", (Object)batchId);
        }
    }

    private void buildAndStoreExecutionCompletedEvent(String jobId, String executionId, int numberOfBatches, int batchLimit, int spaceCount, boolean includesHistoricalData, long startTimeEpocMilli, long waitingTimeEpocMilli, long endTimeEpocMilli) {
        try {
            EventDto eventDto = this.analyticsEventBuilder.buildSpaceStatisticCalculationJobExecutionCompletedEvent(jobId, executionId, spaceCount, numberOfBatches, batchLimit, includesHistoricalData, startTimeEpocMilli, waitingTimeEpocMilli, endTimeEpocMilli);
            this.analyticsEventService.saveAnalyticsEvent(eventDto);
        }
        catch (Exception e) {
            log.error("Failed to store analytics for executionId {}", (Object)executionId);
        }
    }

    private class StorageResult {
        boolean success;
        int errorCount;

        @Generated
        public StorageResult(boolean success, int errorCount) {
            this.success = success;
            this.errorCount = errorCount;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public int getErrorCount() {
            return this.errorCount;
        }
    }

    private class CalculationResult {
        boolean success;
        List<SpaceStatistic> spaceStatistics;

        @Generated
        public CalculationResult(boolean success, List<SpaceStatistic> spaceStatistics) {
            this.success = success;
            this.spaceStatistics = spaceStatistics;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public List<SpaceStatistic> getSpaceStatistics() {
            return this.spaceStatistics;
        }
    }
}

