/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.entity.GuardrailsResponse;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvOutputStreamResult;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseStore;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

public class InstanceAssessmentCSVService {
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentCSVService.class);
    private final BootstrapManager bootstrapManager;
    private final GuardrailsResponseStore guardrailsResponseStore;

    public InstanceAssessmentCSVService(BootstrapManager bootstrapManager, GuardrailsResponseStore guardrailsResponseStore) {
        this.bootstrapManager = bootstrapManager;
        this.guardrailsResponseStore = guardrailsResponseStore;
    }

    public GuardrailsCsvOutputStreamResult generate(String jobId, String fileName, OutputStream outputStream) {
        try {
            Path guardrailsCsvFilePath = this.createGuardrailsCsvFile(jobId, fileName).orElse(null);
            if (guardrailsCsvFilePath == null) {
                log.error("No records found");
                return GuardrailsCsvOutputStreamResult.failed(outputStream, true, new RuntimeException("No records found"));
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));){
                this.addCsvToZip(zipOutputStream, guardrailsCsvFilePath);
            }
            return GuardrailsCsvOutputStreamResult.succeeded(outputStream);
        }
        catch (Exception e) {
            log.error("Unable to generate file for download: {} - {} - {}", new Object[]{jobId, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)});
            return GuardrailsCsvOutputStreamResult.failed(outputStream, false, new RuntimeException("Unable to generate file for download: ${e.message}"));
        }
    }

    public Optional<Path> createGuardrailsCsvFile(String jobId, String fileName) throws IOException {
        String[] fileHeaders = new String[]{"QueryId", "QueryResponse", "Success"};
        List<GuardrailsResponse> guardrailsResponses = this.guardrailsResponseStore.getResponses(jobId);
        return guardrailsResponses.isEmpty() ? Optional.empty() : Optional.of(this.createCsv(fileName, fileHeaders, guardrailsResponses));
    }

    private Path createCsv(String fileName, String[] fileHeaders, List<GuardrailsResponse> guardrailsResponses) throws IOException {
        StreamingOutput csvStreamingOutput = output -> {
            try (CsvBeanWriter csvBeanWriter = new CsvBeanWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);){
                csvBeanWriter.writeHeader(fileHeaders);
                for (GuardrailsResponse response : guardrailsResponses) {
                    csvBeanWriter.write((Object)response, fileHeaders);
                }
            }
            catch (IOException e) {
                throw new IOException("Unable to generate CSV file for instance assessment", e);
            }
        };
        Path csvFilePath = this.getFilePath(fileName.concat(".csv"));
        Files.deleteIfExists(csvFilePath);
        Files.createDirectories(this.getPath(), new FileAttribute[0]);
        Files.createFile(csvFilePath, new FileAttribute[0]);
        csvStreamingOutput.write(Files.newOutputStream(csvFilePath, new OpenOption[0]));
        return csvFilePath;
    }

    private void addCsvToZip(ZipOutputStream zipOutputStream, Path filePath) throws IOException {
        String resolvedZipEntryName = filePath.getFileName().toString();
        zipOutputStream.putNextEntry(new ZipEntry(resolvedZipEntryName));
        Files.copy(filePath, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private Path getFilePath(String fileName) {
        return this.getPath().resolve(fileName);
    }

    private Path getPath() {
        return Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), "guardrails");
    }
}

