/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.fx3.Fx3Client;
import com.atlassian.fx3.httpclient.HttpCallback;
import com.atlassian.fx3.setup.Fx3Config;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.featureflag.Fx3OkhttpAdapter;
import com.atlassian.sal.api.license.LicenseHandler;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fx3ClientHandler {
    private Fx3Client fx3Client = null;
    private static final Logger log = LoggerFactory.getLogger(Fx3ClientHandler.class);

    public Fx3ClientHandler(Fx3OkhttpAdapter fx3OkhttpAdapter, MigrationAgentConfiguration migrationAgentConfiguration, LicenseHandler licenseHandler) {
        try {
            Fx3Config fx3Config = new Fx3Config(migrationAgentConfiguration.getFx3FetcherEnvironment(), migrationAgentConfiguration.getFx3EnvironmentKey());
            HashMap<String, String> customAttributes = new HashMap<String, String>();
            customAttributes.put("ServerId", licenseHandler.getServerId());
            this.fx3Client = Fx3Client.Companion.init(fx3Config, customAttributes, (HttpCallback)fx3OkhttpAdapter);
        }
        catch (Exception e) {
            log.error("Error occurred while initializing Fx3Client with message : {}", (Object)e.getMessage());
        }
    }

    public Fx3Client getFx3Client() {
        return this.fx3Client;
    }
}

