/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration;

import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.collect.ImmutableSet;

public class MigrationDarkFeaturesManager {
    public static final String PLUGIN_FLAG_PREFIX = "migration-assistant.";
    public static final String HANDLE_INVALID_DUPLICATE_EMAIL_USERS = "migration-assistant.handle-invalid-duplicate-email-users";
    public static final String ENABLE_NEW_SPACE_EXPORT = "migration-assistant.enable.new-space-export";
    public static final String ENABLE_XML_TO_CSV_MCS_UPLOAD = "migration-assistant.enable.xml-to-csv.mcs-upload";
    public static final String APP_MIGRATION_DEV_MODE = "migration-assistant.app-migration.dev-mode";
    public static final String ENABLE_APP_MIGRATION_RERUN = "migration-assistant.app-migration.rerun";
    public static final String ENABLE_EXPORT_CACHING = "migration-assistant.enable.export-caching";
    public static final String DISABLE_MISSING_ATTACHMENTS_CHECK = "migration-assistant.disable.missing-attachments-check";
    public static final String DISABLE_NETWORK_HEALTH_PREFLIGHT_CHECK = "migration-assistant.disable.network-health-check";
    public static final String DISABLE_APP_OUTDATED_CHECK = "migration-assistant.disable.app-outdated-check";
    public static final String ENABLE_SPACE_FILTERS = "migration-assistant.enable.space-filters";
    public static final String DISABLE_TASK_LIST_FEATURE = "migration-assistant.disable.task-list.feature";
    public static final String ENABLE_EXPORT_ONLY = "migration-assistant.enable.export-only";
    public static final String ENABLE_UPLOAD_ONLY = "migration-assistant.enable.upload-only";
    public static final String SKIP_ATTACHMENTS_UPLOAD = "migration-assistant.skip.attachments.upload";
    public static final String DISABLED_PLAN_EDIT_FEATURES = "migration-assistant.plan.edit.features.disabled";
    public static final String SCOPED_USERS_GROUPS_MENTIONS = "migration-assistant.enable.scoped-users-groups-mentions";
    public static final String DISABLE_APP_VENDOR_CHECK = "migration-assistant.disable.app-vendor-check";
    public static final String ENABLE_APP_VENDOR_CHECK_FILTER = "enable.app-vendor-check-filter";
    public static final String DISABLE_SCHEDULER_FIXES = "migration-assistant.disable.scheduler.fixes";
    public static final String DISABLE_SINGLE_MEDIA_UPLOAD_TOKEN_API = "migration-assistant.disable.single-media-upload-token-api";
    public static final String DISABLE_CHECKS_BEFORE_RUN = "migration-assistant.disable.checks-before-run";
    public static final String ENABLE_ORIGINAL_XML_EXPORT = "migration-assistant.enable.original-xml-export";
    public static final String ENABLE_SPACE_USERS_MIGRATIONS_STEP = "migration-assistant.enable.space-users-migration-step";
    public static final String DISABLE_LICENCE_CHECK = "migration-assistant.disable.licence-check";
    public static final String ENABLE_NEW_SPACE_SELECTOR = "migration-assistant.enable.new-space-selector-feature";
    public static final String ENABLE_UNLIMITED_SPACE_IMPORT_CONCURRENCY = "migration-assistant.enable.unlimited-space-import-concurrency";
    public static final String ENABLE_FED_RAMP = "migration-assistant.enable.fedRAMP";
    public static final String ENABLE_GLOBAL_ENTITIES = "migration-assistant.enable.global-entities";
    public static final String ENABLE_FORCE_RESET_FLAG = "migration-assistant.enable.force-reset-flag";
    public static final String ENABLE_TOKEN_ENCRYPTION = "migration-assistant.enable.token.encryption";
    private boolean batchingEnabled;
    public static final String MIGRATION_ASSISTANT_HANDLE_INVALID_DUPLICATE_EMAIL_USERS = "migration-assistant.handle-invalid-duplicate-email-users";
    public static final String MIGRATION_ASSISTANT_ENABLE_GLOBAL_EMAIL_FIXES_FEATURE = "migration-assistant.global.email.fixes.feature";
    public static final String MIGRATION_ASSISTANT_DISABLE_GLOBAL_EMAIL_FIXES_SEND_TOMBSTONES_FEATURE = "migration-assistant.disable.global.email.fixes.send-tombstones.feature";
    public static final String MIGRATION_ASSISTANT_ENABLE_NEW_SPACE_EXPORT = "migration-assistant.enable.new-space-export";
    public static final String MIGRATION_ASSISTANT_ENABLE_XML_TO_CSV_MCS_UPLOAD = "migration-assistant.enable.xml-to-csv.mcs-upload";
    private final DarkFeatureManager darkFeatureManager;
    private final FeatureFlagClient featureFlagClient;

    public MigrationDarkFeaturesManager(DarkFeatureManager darkFeatureManager, FeatureFlagClient featureFlagClient) {
        this.darkFeatureManager = darkFeatureManager;
        this.featureFlagClient = featureFlagClient;
    }

    private boolean isFeatureEnabled(String key) {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(key);
    }

    public ImmutableSet<String> getAllEnabledFeatures() {
        return this.darkFeatureManager.getFeaturesEnabledForAllUsers().getFeatureKeys();
    }

    public boolean appMigrationDevMode() {
        return this.isFeatureEnabled(APP_MIGRATION_DEV_MODE);
    }

    public boolean isAppMigrationRerunEnabled() {
        return this.isFeatureEnabled(ENABLE_APP_MIGRATION_RERUN);
    }

    public boolean newExportEnabled() {
        return this.isFeatureEnabled("migration-assistant.enable.new-space-export");
    }

    public boolean exportCachingEnabled() {
        return this.isFeatureEnabled(ENABLE_EXPORT_CACHING);
    }

    public boolean missingAttachmentsCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_MISSING_ATTACHMENTS_CHECK);
    }

    public boolean networkHealthCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_NETWORK_HEALTH_PREFLIGHT_CHECK);
    }

    public boolean appOutdatedCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_APP_OUTDATED_CHECK);
    }

    public boolean spaceFiltersEnabled() {
        return this.isFeatureEnabled(ENABLE_SPACE_FILTERS);
    }

    public boolean isPlanEditFeaturesDisabled() {
        return this.isFeatureEnabled(DISABLED_PLAN_EDIT_FEATURES);
    }

    public boolean skipAttachmentUploadEnabled() {
        return this.isFeatureEnabled(SKIP_ATTACHMENTS_UPLOAD);
    }

    public boolean shouldHandleInvalidAndDuplicateEmailUsers() {
        return this.isFeatureEnabled("migration-assistant.handle-invalid-duplicate-email-users");
    }

    public boolean shouldHandleGlobalEmailFixes() {
        return this.isGlobalEmailFixesFeatureEnabled();
    }

    boolean isGlobalEmailFixesFeatureEnabled() {
        return this.isFeatureEnabled(MIGRATION_ASSISTANT_ENABLE_GLOBAL_EMAIL_FIXES_FEATURE);
    }

    public boolean isGlobalEmailFixesSendTombstonesFeatureDisabled() {
        return this.isFeatureEnabled(MIGRATION_ASSISTANT_DISABLE_GLOBAL_EMAIL_FIXES_SEND_TOMBSTONES_FEATURE) || this.featureFlagClient.isFeatureEnabled(MIGRATION_ASSISTANT_DISABLE_GLOBAL_EMAIL_FIXES_SEND_TOMBSTONES_FEATURE);
    }

    public boolean isExportOnlyEnabled() {
        return this.isFeatureEnabled(ENABLE_EXPORT_ONLY);
    }

    public boolean isXMLToCSVAndUploadToMCSEnabled() {
        return this.isFeatureEnabled("migration-assistant.enable.xml-to-csv.mcs-upload");
    }

    public boolean isTasklistFeatureDisabled() {
        return this.isFeatureEnabled(DISABLE_TASK_LIST_FEATURE);
    }

    public boolean isScopedUsersGroupsWithMentionsEnabled() {
        return this.isFeatureEnabled(SCOPED_USERS_GROUPS_MENTIONS);
    }

    public boolean appVendorCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_APP_VENDOR_CHECK);
    }

    public boolean isSchedulerFixEnabled() {
        return !this.isFeatureEnabled(DISABLE_SCHEDULER_FIXES);
    }

    public boolean appVendorChecksFilterEnabled() {
        return this.isFeatureEnabled(ENABLE_APP_VENDOR_CHECK_FILTER);
    }

    public boolean isUploadOnlyEnabled() {
        return this.isFeatureEnabled(ENABLE_UPLOAD_ONLY);
    }

    public boolean isDisableSingleMediaUploadTokenApi() {
        return this.isFeatureEnabled(DISABLE_SINGLE_MEDIA_UPLOAD_TOKEN_API);
    }

    public boolean isPreflightChecksDisabledBeforeRun() {
        return this.isFeatureEnabled(DISABLE_CHECKS_BEFORE_RUN);
    }

    public boolean isEnableOriginalXMLExport() {
        return this.isFeatureEnabled(ENABLE_ORIGINAL_XML_EXPORT);
    }

    public boolean isSpaceUsersMigrationStepEnabled() {
        return this.isFeatureEnabled(ENABLE_SPACE_USERS_MIGRATIONS_STEP);
    }

    public boolean isLicenceCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_LICENCE_CHECK);
    }

    public boolean isNewSpaceSelectorEnabled() {
        return this.isFeatureEnabled(ENABLE_NEW_SPACE_SELECTOR);
    }

    public boolean isUnlimitedSpaceImportConcurrencyEnabled() {
        return this.batchingEnabled;
    }

    public void refreshBatchingFlag() {
        this.batchingEnabled = this.isFeatureEnabled(ENABLE_UNLIMITED_SPACE_IMPORT_CONCURRENCY) || this.featureFlagClient.isFeatureEnabled(ENABLE_UNLIMITED_SPACE_IMPORT_CONCURRENCY);
    }

    public boolean fedRAMPEnabled() {
        return this.isFeatureEnabled(ENABLE_FED_RAMP);
    }

    public boolean isGlobalEntitiesMigrationEnabled() {
        return this.isFeatureEnabled(ENABLE_GLOBAL_ENTITIES);
    }

    public boolean isForceResetFlagEnabled() {
        return this.isFeatureEnabled(ENABLE_FORCE_RESET_FLAG);
    }

    public boolean isTokenEncryptionEnabled() {
        return this.isFeatureEnabled(ENABLE_TOKEN_ENCRYPTION);
    }
}

