/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.results;

import com.atlassian.migration.agent.store.guardrails.GrResult;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class JiraIssueMacroPerPageTopKQueryResult
implements GrResult,
L1AssessmentResult {
    @JsonProperty
    private final List<Tuple> result;
    @JsonIgnore
    private int k;

    public JiraIssueMacroPerPageTopKQueryResult(List<Tuple> result, int k) {
        this.k = k;
        this.result = result == null ? new ArrayList() : this.formatResult(result);
    }

    private List<Tuple> formatResult(List<Tuple> result) {
        return result.stream().map(tuple -> GuardrailsUtil.getTuple(Arrays.asList((Serializable)tuple.get(0, Long.class), (Serializable)tuple.get(1, String.class), (Serializable)tuple.get(2, String.class), this.getJIMCount((String)tuple.get(3, String.class))))).sorted((o1, o2) -> ((String)o2.get(3, String.class)).compareTo((String)o1.get(3, String.class))).limit(this.k).collect(Collectors.toList());
    }

    private String getJIMCount(String stringVal) {
        String[] vals = stringVal.split("-");
        return vals.length >= 2 ? vals[1] : "0";
    }

    @Override
    public String generateGrResult() {
        return GuardrailsUtil.formatTupleList(this.result, Long.class, String.class, String.class, String.class);
    }

    @Override
    public String generateL1AssessmentData() {
        return GuardrailsUtil.formatTupleList(this.result, Long.class, String.class, String.class, String.class);
    }
}

