/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.stepexecutor.space.CreateTombstoneAccountRequest;
import com.atlassian.migration.agent.service.stepexecutor.space.PublishTombstoneMappingRequest;
import com.atlassian.migration.agent.service.stepexecutor.space.TombstoneAccountsResponse;
import com.atlassian.migration.agent.service.user.CloudEditionCheckResponse;
import com.atlassian.migration.agent.service.user.DefaultUsersMigrationService;
import com.atlassian.migration.agent.service.user.GroupConflictsCheckRequest;
import com.atlassian.migration.agent.service.user.GroupsConflictCheckResponse;
import com.atlassian.migration.agent.service.user.UsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationStatusResponse;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2Request;
import javax.annotation.ParametersAreNonnullByDefault;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;

@ParametersAreNonnullByDefault
public class RetryingUsersMigrationService
implements UsersMigrationService {
    private final UsersMigrationService wrapped;
    private final RetryPolicy retryPolicy;
    private final RetryPolicy initiateUsersRetryPolicy;

    public RetryingUsersMigrationService(DefaultUsersMigrationService wrapped) {
        this.wrapped = wrapped;
        this.retryPolicy = RetryPolicyBuilder.policyForUserMigrationService();
        this.initiateUsersRetryPolicy = RetryPolicyBuilder.policyForInitiateUsersAndGroups();
    }

    @Override
    public String initiateUsersAndGroupsMigrationV2(String containerToken, UsersMigrationV2Request usersAndGroups) {
        return (String)Failsafe.with((RetryPolicy)this.initiateUsersRetryPolicy).get(() -> this.wrapped.initiateUsersAndGroupsMigrationV2(containerToken, usersAndGroups));
    }

    @Override
    public UsersMigrationStatusResponse getUsersAndGroupsMigrationProgress(String containerToken, String taskId) {
        return (UsersMigrationStatusResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.getUsersAndGroupsMigrationProgress(containerToken, taskId));
    }

    @Override
    public String startGroupConflictsCheck(String containerToken, GroupConflictsCheckRequest groupNamesCheckRequest) {
        return (String)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.startGroupConflictsCheck(containerToken, groupNamesCheckRequest));
    }

    @Override
    public GroupsConflictCheckResponse getGroupConflictsCheckStatus(String containerToken, String taskId) {
        return (GroupsConflictCheckResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.getGroupConflictsCheckStatus(containerToken, taskId));
    }

    @Override
    public CloudEditionCheckResponse getCloudEditionCheck(String containerToken) {
        return (CloudEditionCheckResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.getCloudEditionCheck(containerToken));
    }

    @Override
    public UsersMigrationStatusResponse cancelUsersAndGroupsMigration(String containerToken, String taskId) {
        return (UsersMigrationStatusResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.cancelUsersAndGroupsMigration(containerToken, taskId));
    }

    @Override
    public TombstoneAccountsResponse createTombstoneAccounts(String containerToken, int numOfUsers, CreateTombstoneAccountRequest request) {
        return (TombstoneAccountsResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.createTombstoneAccounts(containerToken, numOfUsers, request));
    }

    @Override
    public void publishTombstoneMappings(String containerToken, PublishTombstoneMappingRequest request) {
        Failsafe.with((RetryPolicy)this.retryPolicy).run(() -> this.wrapped.publishTombstoneMappings(containerToken, request));
    }
}

