/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.MigrationDarkFeaturesValidator;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.dto.ConfExportStepConfig;
import com.atlassian.migration.agent.entity.ExportCacheEntry;
import com.atlassian.migration.agent.entity.ExportType;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.export.MigrationExportException;
import com.atlassian.migration.agent.export.SpaceNoAttachmentsXmlExporter;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.newexport.SpaceCSVExportTaskContext;
import com.atlassian.migration.agent.newexport.SpaceRapidExporter;
import com.atlassian.migration.agent.newexport.util.FileUtil;
import com.atlassian.migration.agent.rest.IncompatibleDarkFeatureException;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.ClusterLimits;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.ServiceInitializeException;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.execution.SpaceBoundStepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.ExportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.service.stepexecutor.export.SpaceExportCacheService;
import com.atlassian.migration.agent.service.stepexecutor.space.AtlassianAccountPostProcessor;
import com.atlassian.migration.agent.service.stepexecutor.space.CSVConverterService;
import com.atlassian.migration.agent.service.stepexecutor.space.InlineTasksPostprocessor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportCustomContentEntityPostProcessor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportPostProcessor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportResult;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceExportExecutor
extends ExportExecutor
implements SpaceBoundStepExecutor {
    @VisibleForTesting
    static final StepType EXPORT_STEP_TYPE = StepType.CONFLUENCE_EXPORT;
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportExecutor.class);
    private final AttachmentService attachmentService;
    private final SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter;
    private final SpaceExportPostProcessor spaceExportPostProcessor;
    private final SpaceExportCustomContentEntityPostProcessor spaceExportCustomContentEntityPostProcessor;
    private final InlineTasksPostprocessor inlineTasksPostprocessor;
    private final AtlassianAccountPostProcessor aaidPopulatorPostProcessor;
    private final CSVConverterService csvConverterService;
    private final SpaceExportCacheService cacheService;
    private final SpaceManager spaceManager;
    private final SpaceRapidExporter rapidExporter;
    private final Supplier<String> fileIdGenerator;
    private final ClusterLimits clusterLimits;

    public SpaceExportExecutor(SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, ExportDirManager exportDirManager, BootstrapManager bootstrapManager, AttachmentService attachmentService, StepStore stepStore, PluginTransactionTemplate ptx, SpaceExportPostProcessor spaceExportPostProcessor, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, SpaceExportCustomContentEntityPostProcessor spaceExportCustomContentEntityPostProcessor, InlineTasksPostprocessor inlineTasksPostprocessor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationDarkFeaturesValidator migrationDarkFeaturesValidator, SpaceRapidExporter rapidExporter, AtlassianAccountPostProcessor aaidPopulatorPostProcessor, SpaceExportCacheService cacheService, CSVConverterService converterService, SpaceManager spaceManager, MigrationAgentConfiguration migrationAgentConfiguration, ClusterLimits clusterLimits) {
        super(stepSchedulerService, schedulerService, exportDirManager, bootstrapManager, stepStore, ptx, analyticsEventService, analyticsEventBuilder, migrationDarkFeaturesManager, migrationDarkFeaturesValidator, migrationAgentConfiguration);
        this.spaceNoAttachmentsXmlExporter = spaceNoAttachmentsXmlExporter;
        this.attachmentService = attachmentService;
        this.spaceExportPostProcessor = spaceExportPostProcessor;
        this.spaceExportCustomContentEntityPostProcessor = spaceExportCustomContentEntityPostProcessor;
        this.inlineTasksPostprocessor = inlineTasksPostprocessor;
        this.aaidPopulatorPostProcessor = aaidPopulatorPostProcessor;
        this.csvConverterService = converterService;
        this.cacheService = cacheService;
        this.spaceManager = spaceManager;
        this.rapidExporter = rapidExporter;
        this.fileIdGenerator = () -> UUID.randomUUID().toString();
        this.clusterLimits = clusterLimits;
    }

    @VisibleForTesting
    SpaceExportExecutor(SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, ExportDirManager exportDirManager, BootstrapManager bootstrapManager, AttachmentService attachmentService, StepStore stepStore, PluginTransactionTemplate ptx, SpaceExportPostProcessor spaceExportPostProcessor, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, SpaceExportCustomContentEntityPostProcessor spaceExportCustomContentEntityPostProcessor, InlineTasksPostprocessor inlineTasksPostprocessor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationDarkFeaturesValidator migrationDarkFeaturesValidator, SpaceRapidExporter rapidExporter, AtlassianAccountPostProcessor aaidPopulatorPostProcessor, SpaceExportCacheService cacheService, CSVConverterService converterService, SpaceManager spaceManager, MigrationAgentConfiguration migrationAgentConfiguration, Clock clock, Supplier<String> fileIdGenerator, ClusterLimits clusterLimits) {
        super(stepSchedulerService, schedulerService, exportDirManager, bootstrapManager, stepStore, ptx, instantSupplier, analyticsEventService, analyticsEventBuilder, migrationDarkFeaturesManager, migrationDarkFeaturesValidator, migrationAgentConfiguration, clock);
        this.spaceNoAttachmentsXmlExporter = spaceNoAttachmentsXmlExporter;
        this.attachmentService = attachmentService;
        this.spaceExportPostProcessor = spaceExportPostProcessor;
        this.spaceExportCustomContentEntityPostProcessor = spaceExportCustomContentEntityPostProcessor;
        this.inlineTasksPostprocessor = inlineTasksPostprocessor;
        this.aaidPopulatorPostProcessor = aaidPopulatorPostProcessor;
        this.csvConverterService = converterService;
        this.cacheService = cacheService;
        this.spaceManager = spaceManager;
        this.rapidExporter = rapidExporter;
        this.fileIdGenerator = fileIdGenerator;
        this.clusterLimits = clusterLimits;
    }

    @Override
    protected JobRunnerKey getJobRunnerKey() {
        return JobRunnerKey.of((String)"migration-plugin:space-export-executor");
    }

    @Override
    protected int getExportExecutorConcurrencyNumber() {
        return this.migrationAgentConfiguration.getSpaceExportExecutorConcurrency();
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get("stepId");
        String config = (String)request.getJobConfig().getParameters().get("stepConfig");
        Step step = this.stepStore.getStep(stepId);
        this.stepSchedulerService.runStep(stepId, EXPORT_STEP_TYPE, () -> {
            ConfExportStepConfig exportStepConfig = Jsons.readValue(config, ConfExportStepConfig.class);
            String spaceKey = exportStepConfig.getSpaceKey();
            return this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doExport(exportStepConfig, stepId));
        });
        return null;
    }

    @VisibleForTesting
    StepResult doExport(ConfExportStepConfig exportStepConfig, String stepId) {
        try {
            this.migrationDarkFeaturesValidator.assertSpaceExportFeaturesAreValid();
        }
        catch (IncompatibleDarkFeatureException ex) {
            log.error("Space Export Dark features are not compatible: {}", (Object)ex.getMessage());
            return StepResult.failed(String.format("Space export failed due to Incompatible dark features: %s", ex.getMessage()), ex);
        }
        ExportType exportType = this.getExportType();
        long startTime = ((Instant)this.instantSupplier.get()).toEpochMilli();
        long freeHeapSizeAtStart = Runtime.getRuntime().freeMemory();
        Step step = this.stepStore.getStep(stepId);
        String planId = step.getPlan().getId();
        String migrationId = step.getPlan().getMigrationId();
        String cloudId = exportStepConfig.getCloudId();
        String spaceKey = exportStepConfig.getSpaceKey();
        String fileId = this.fileIdGenerator.get();
        log.info("Initiating space export for spaceKey: {} planId: {} migrationId: {} exportType:{} fileId: {}", new Object[]{spaceKey, planId, migrationId, exportType, fileId});
        if (StringUtils.isBlank((String)spaceKey)) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_NO_SPACE_KEY, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_NO_SPACE_KEY.getMessage(), spaceKey);
            return StepResult.failed("Attempted to perform an export, but no space key was found.");
        }
        if (StringUtils.isBlank((String)cloudId)) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_NO_CLOUD_ID, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_NO_CLOUD_ID.getMessage(), spaceKey);
            return StepResult.failed("Attempted to perform an export, but no cloud ID was found.");
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_SPACE_DOES_NOT_EXIST, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_SPACE_DOES_NOT_EXIST.getMessage(), spaceKey);
            return StepResult.failed(String.format("Attempted to perform an export, but no space with the key '%s' was found.", spaceKey));
        }
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceExportStartEvent(step, exportType, space.getId(), startTime));
        return this.exportProcessor(step, exportStepConfig, startTime, freeHeapSizeAtStart, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepResult exportProcessor(Step step, ConfExportStepConfig exportStepConfig, long startTime, long freeHeapSizeAtStart, String fileId) {
        ExportType exportType = this.getExportType();
        String migrationId = step.getPlan().getMigrationId();
        String spaceKey = exportStepConfig.getSpaceKey();
        String cloudId = exportStepConfig.getCloudId();
        String planId = step.getPlan().getId();
        String taskId = step.getTask().getId();
        boolean containsUserMigrationTask = this.containsTask(step.getPlan(), MigrateUsersTask.class);
        boolean success = false;
        SpaceExportResult exportResult = null;
        try {
            exportResult = this.exportedFileGenerator(spaceKey, planId, taskId, fileId, containsUserMigrationTask, cloudId);
            String exportedFile = exportResult.getExportFile();
            if (exportType.equals((Object)ExportType.ORIGINAL) || exportType.equals((Object)ExportType.XML_TO_CSV)) {
                Path exportedFilePath = Paths.get(exportedFile, new String[0]);
                this.spaceExportPostProcessor.postprocess(exportedFilePath, spaceKey, planId, taskId, containsUserMigrationTask);
                log.info("Exporting space for spaceKey: {} planId: {} migrationId: {}", new Object[]{spaceKey, planId, migrationId});
                this.spaceExportCustomContentEntityPostProcessor.postprocess(exportedFilePath, Collections.singletonList("com.atlassian"));
                this.aaidPopulatorPostProcessor.postprocess(planId, exportedFilePath);
                this.inlineTasksPostprocessor.postprocess(exportedFilePath, containsUserMigrationTask);
            }
            if (!this.migrationDarkFeaturesManager.isExportOnlyEnabled()) {
                if (exportType.equals((Object)ExportType.XML_TO_CSV)) {
                    long conversionStartTime = ((Instant)this.instantSupplier.get()).toEpochMilli();
                    try {
                        log.info("Preparing to convert export files to compressed files {} for migrationId: {}", (Object)exportedFile, (Object)migrationId);
                        String xmlConversionDir = this.csvConverterService.convertXMLtoCSV(exportedFile, spaceKey);
                        log.info("XmlToCSV conversion output directory: {}", (Object)xmlConversionDir);
                        this.exportDirManager.moveCompressedFilesToSharedHome(xmlConversionDir, fileId);
                        this.buildAndSaveConversionTimerEvent(true, ((Instant)this.instantSupplier.get()).toEpochMilli() - conversionStartTime, spaceKey, step);
                    }
                    catch (Exception ex) {
                        log.error("Unable to convert xml to csv for migrationId: {} with ex: {}", (Object)migrationId, (Object)ex);
                        this.buildAndSaveConversionTimerEvent(false, ((Instant)this.instantSupplier.get()).toEpochMilli() - conversionStartTime, spaceKey, step);
                        success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.XML_TO_CSV_CONVERSION_ERROR, exportType, migrationId, cloudId, ex.getMessage(), spaceKey);
                        StepResult stepResult = StepResult.failed(String.format("Failed to export %s. Error: %s", exportStepConfig, ex.getMessage()), ex);
                        ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"exportType", (Object)exportType.name());
                        EventDto completedStepEvent = this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step, () -> SpaceExportExecutor.lambda$exportProcessor$4((Map)additionalAttributes));
                        EventDto heapSizeAnalyticsEvent = this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(step, freeHeapSizeAtStart, this.clusterLimits.getClusterConcurrencyLimit(StepType.CONFLUENCE_EXPORT), this.clusterLimits.getConcurrencyPerNodeLimit(StepType.CONFLUENCE_EXPORT));
                        EventDto timerEvent = this.analyticsEventBuilder.buildSpaceExportStepTimerEvent(success, ((Instant)this.instantSupplier.get()).toEpochMilli() - startTime, spaceKey, step, exportType, this.createAdditionalAttributes(Optional.ofNullable(exportResult)));
                        this.analyticsEventService.saveAnalyticsEvents(() -> ImmutableList.of((Object)completedStepEvent, (Object)heapSizeAnalyticsEvent, (Object)timerEvent));
                        return stepResult;
                    }
                } else if (exportType.equals((Object)ExportType.RAPID)) {
                    log.info("Moving csv files in {} to {} inside migration exports directory for migrationId: {}", new Object[]{exportedFile, fileId, migrationId});
                    this.exportDirManager.moveCompressedFilesToSharedHome(exportedFile, fileId);
                } else {
                    log.info("Export file {} will be moved to {} for migrationId: {}", new Object[]{exportedFile, fileId, migrationId});
                    this.exportDirManager.moveExportedFileToSharedHome(exportedFile, fileId);
                }
            }
            this.buildAndSaveMetricsWhenStepSucceeds(exportType);
            success = true;
            log.info("Space export successful for spaceKey: {} planId: {} migrationId: {}", new Object[]{spaceKey, planId, migrationId});
            StepResult conversionStartTime = StepResult.succeeded("Data export successful", fileId);
            return conversionStartTime;
        }
        catch (UncheckedInterruptedException | InterruptedException ex) {
            if (this.migrationDarkFeaturesManager.isSchedulerFixEnabled()) {
                StepResult stepResult = StepResult.stopped();
                return stepResult;
            }
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_INTERRUPTED, exportType, migrationId, cloudId, ex.getMessage(), spaceKey);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_INTERRUPTED);
            return stepResult;
        }
        catch (MigrationExportException ex) {
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_FILE_EXPORT_FAILED, exportType, migrationId, cloudId, ex.getMessage(), spaceKey);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_FILE_EXPORT_FAILED);
            return stepResult;
        }
        catch (ServiceInitializeException ex) {
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_DIRECTORY_CREATION_FAILED, exportType, migrationId, cloudId, ex.getMessage(), spaceKey);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_DIRECTORY_CREATION_FAILED);
            return stepResult;
        }
        catch (Exception ex) {
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_EXECUTION_ERROR, exportType, migrationId, cloudId, ex.getMessage(), spaceKey);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_EXECUTION_ERROR);
            return stepResult;
        }
        finally {
            ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"exportType", (Object)exportType.name());
            EventDto completedStepEvent = this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step, () -> SpaceExportExecutor.lambda$exportProcessor$4((Map)additionalAttributes));
            EventDto heapSizeAnalyticsEvent = this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(step, freeHeapSizeAtStart, this.clusterLimits.getClusterConcurrencyLimit(StepType.CONFLUENCE_EXPORT), this.clusterLimits.getConcurrencyPerNodeLimit(StepType.CONFLUENCE_EXPORT));
            EventDto timerEvent = this.analyticsEventBuilder.buildSpaceExportStepTimerEvent(success, ((Instant)this.instantSupplier.get()).toEpochMilli() - startTime, spaceKey, step, exportType, this.createAdditionalAttributes(Optional.ofNullable(exportResult)));
            this.analyticsEventService.saveAnalyticsEvents(() -> ImmutableList.of((Object)completedStepEvent, (Object)heapSizeAnalyticsEvent, (Object)timerEvent));
        }
    }

    private Map<String, Object> createAdditionalAttributes(Optional<SpaceExportResult> maybeExportResult) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("dbType", this.migrationAgentConfiguration.getDBType().name());
        maybeExportResult.ifPresent(exportResult -> attributes.putAll(exportResult.getAttributes()));
        return attributes;
    }

    private SpaceExportResult exportedFileGenerator(String spaceKey, String planId, String taskId, String fileId, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        ExportType exportType = this.getExportType();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (this.migrationDarkFeaturesManager.exportCachingEnabled()) {
            return this.exportSpaceContentViaCache(space.getId(), spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
        }
        return this.exportSpaceContentToFile(space.getId(), spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
    }

    protected SpaceExportResult exportSpaceContentViaCache(long spaceId, String spaceKey, String planId, String taskId, String fileId, ExportType exportType, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        Optional<ExportCacheEntry> maybeCachedValue = this.cacheService.getCacheEntry(spaceKey, exportType, containsUserMigrationTask, cloudId);
        if (maybeCachedValue.isPresent()) {
            ExportCacheEntry cachedValue = maybeCachedValue.get();
            log.info("Using cached export id: {} file: {}", (Object)cachedValue.getId(), (Object)cachedValue.getFilePath());
            return new SpaceExportResult(this.copyCachedFileToTmpDir(spaceKey, fileId, cachedValue.getFilePath()).toString(), Collections.emptyMap());
        }
        return this.generateAndCacheExportFile(spaceId, spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpaceExportResult exportSpaceContentToFile(long spaceId, String spaceKey, String planId, String taskId, String fileId, ExportType exportType, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        if (exportType.equals((Object)ExportType.RAPID)) {
            SpaceCSVExportTaskContext config = new SpaceCSVExportTaskContext(spaceId, spaceKey, cloudId, planId, taskId, this.tempDirFilePath.getAbsolutePath(), containsUserMigrationTask);
            String exportedFile = this.rapidExporter.export(config);
            this.createExportDirectoryIfNotExists();
            return new SpaceExportResult(exportedFile, (Map<String, Object>)ImmutableMap.of((Object)"totalRowCount", (Object)config.getTotalRowCount(), (Object)"totalCharactersExported", (Object)config.getTotalCharactersExported()));
        }
        try {
            this.attachmentService.prepareMigratedAttachmentsForExport(spaceKey, cloudId);
            String exportedFile = this.spaceNoAttachmentsXmlExporter.doExport(spaceKey, fileId).get();
            SpaceExportResult spaceExportResult = new SpaceExportResult(exportedFile, Collections.emptyMap());
            return spaceExportResult;
        }
        finally {
            this.attachmentService.cleanMigratedAttachmentsAfterExport(spaceKey, cloudId);
        }
    }

    private SpaceExportResult generateAndCacheExportFile(long spaceId, String spaceKey, String planId, String taskId, String fileId, ExportType exportType, boolean containsUserMigrationTask, String cloudId) throws ExecutionException, InterruptedException {
        long now = Instant.now(this.clock).toEpochMilli();
        log.info("Generating export file for fileId={} spaceKey={}, exportType={}, containsUserMigrationTask={}, snapshotTime={}", new Object[]{fileId, spaceKey, exportType, containsUserMigrationTask, now});
        SpaceExportResult result = this.exportSpaceContentToFile(spaceId, spaceKey, planId, taskId, fileId, exportType, containsUserMigrationTask, cloudId);
        String localFilePath = result.getExportFile();
        String cacheFilePath = this.exportDirManager.copyExportedFileToSharedHome(localFilePath, fileId + "_cache");
        this.cacheService.cacheExportData(now, exportType, spaceKey, cloudId, containsUserMigrationTask, cacheFilePath);
        return result;
    }

    private Path copyCachedFileToTmpDir(String spaceKey, String fileId, String cachedFile) {
        try {
            String exportDir = FileUtil.createExportDirectory(spaceKey, this.tempDirFilePath.getAbsolutePath());
            Path destinationPath = Paths.get(exportDir, new String[0]).resolve(fileId);
            Files.copy(Paths.get(cachedFile, new String[0]), destinationPath, new CopyOption[0]);
            return destinationPath;
        }
        catch (IOException e) {
            throw new MigrationExportException("Unable to copy cached file to tmp dir", e);
        }
    }

    @VisibleForTesting
    ExportType getExportType() {
        if (this.migrationDarkFeaturesManager.isEnableOriginalXMLExport()) {
            return ExportType.ORIGINAL;
        }
        if (this.migrationAgentConfiguration.isDBTypeSupportedForRapidExport() || this.migrationDarkFeaturesManager.newExportEnabled()) {
            return ExportType.RAPID;
        }
        if (this.migrationDarkFeaturesManager.isXMLToCSVAndUploadToMCSEnabled()) {
            return ExportType.XML_TO_CSV;
        }
        return ExportType.ORIGINAL;
    }

    private boolean checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode migrationErrorCode, ExportType exportType, String migrationId, String cloudId, String message, String spaceKey) {
        boolean isSloGoodEvent = migrationErrorCode.shouldBeTreatedAsGoodEventInReliabilitySlo();
        ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(migrationErrorCode, migrationErrorCode.getContainerType(), migrationId, EXPORT_STEP_TYPE).setCloudid(cloudId).setReason(message).setSpaceKey(spaceKey).build();
        ImmutableList events = ImmutableList.of((Object)this.analyticsEventBuilder.buildFailedSpaceMigration(EXPORT_STEP_TYPE, migrationErrorCode), (Object)this.analyticsEventBuilder.buildExportStepCounterEvent(exportType, isSloGoodEvent), (Object)this.analyticsEventBuilder.buildErrorOperationalEventForSpaceExport(errorEvent, exportType));
        this.analyticsEventService.sendAnalyticsEvents(() -> SpaceExportExecutor.lambda$checkIfGoodEventAndSaveAnalyticEventsWhenStepFails$7((List)events));
        return isSloGoodEvent;
    }

    private void buildAndSaveMetricsWhenStepSucceeds(ExportType exportType) {
        this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildExportStepCounterEvent(exportType, true)));
    }

    private void buildAndSaveConversionTimerEvent(boolean success, long duration, String spaceKey, Step step) {
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildXMLToCSVConversionTimerEvent(success, duration, spaceKey, step));
    }

    @Override
    public StepType getStepType() {
        return StepType.CONFLUENCE_EXPORT;
    }

    @Override
    public StepResult runStep(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        ConfExportStepConfig exportStepConfig = Jsons.readValue(step.getConfig(), ConfExportStepConfig.class);
        String spaceKey = exportStepConfig.getSpaceKey();
        return this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doExport(exportStepConfig, stepId));
    }

    private static /* synthetic */ Collection lambda$checkIfGoodEventAndSaveAnalyticEventsWhenStepFails$7(List events) {
        return events;
    }

    private static /* synthetic */ Map lambda$exportProcessor$4(Map additionalAttributes) {
        return additionalAttributes;
    }
}

