/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.mo;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.agent.service.mo.MigrationOrchestratorServiceStatusResponse;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class MigrationOrchestratorClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationOrchestratorClient.class);
    public static final String IS_MAINTENANCE_PATH = "/migrations/service-status";
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final HttpService httpService;
    private final RetryPolicy retryPolicy;
    private final boolean bypassStargate;

    public MigrationOrchestratorClient(MigrationAgentConfiguration migrationAgentConfiguration, UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        this(migrationAgentConfiguration, new HttpService(() -> MigrationOrchestratorClient.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder)), RetryPolicyBuilder.policyForMigrationOrchestratorService());
    }

    @VisibleForTesting
    public MigrationOrchestratorClient(MigrationAgentConfiguration migrationAgentConfiguration, HttpService httpService) {
        this(migrationAgentConfiguration, httpService, RetryPolicyBuilder.policyForMigrationOrchestratorService());
    }

    @VisibleForTesting
    public MigrationOrchestratorClient(MigrationAgentConfiguration migrationAgentConfiguration, HttpService httpService, RetryPolicy retryPolicy) {
        this.bypassStargate = migrationAgentConfiguration.isBypassStargate();
        this.httpService = httpService;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.retryPolicy = retryPolicy;
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(60L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(140L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private Request.Builder getJsonBuilder(String containerToken) {
        return StargateHelper.requestBuilder(containerToken, this.bypassStargate).addHeader("Accept", "application/json");
    }

    public boolean isInMaintenance(String containerToken) {
        Request request = this.getJsonBuilder(containerToken).url(this.getUriBuilder().path(IS_MAINTENANCE_PATH).toUriString()).get().build();
        return this.callJsonWithRetries(request, new TypeReference<MigrationOrchestratorServiceStatusResponse>(){}).getMaintenance();
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.callJson(request, bodyType));
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.migrationAgentConfiguration.getMigrationOrchestratorServiceBaseUrl());
    }
}

