/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.dto.CloudType;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.DefaultTypeSettings;
import com.atlassian.migration.agent.service.impl.MigrationSettingsType;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.codehaus.jackson.type.TypeReference;

public class CloudTypeSettingsService
extends DefaultTypeSettings {
    private static final TypeReference<Map<CloudType, Boolean>> MAP_TYPE_REFERENCE = new TypeReference<Map<CloudType, Boolean>>(){};

    public CloudTypeSettingsService(PluginSettingsFactory pluginSettingsFactory, MigrationAgentConfiguration migrationAgentConfiguration) {
        super(pluginSettingsFactory, migrationAgentConfiguration, MigrationSettingsType.CLOUD_TYPE);
    }

    public Map<CloudType, Boolean> getCloudTypeSettings() {
        return (Map)this.getSettings();
    }

    public void setCloudTypeSettings(Map<CloudType, Boolean> cloudTypeMap) {
        this.putSettings(cloudTypeMap);
    }

    public boolean isCloudTypeEnabled(CloudType cloudType) {
        return this.getCloudTypeSettings().get((Object)cloudType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isValidSettings(Object settingsObj) {
        Map cloudTypeMap = (Map)settingsObj;
        if (cloudTypeMap == null) return false;
        if (cloudTypeMap.isEmpty()) return false;
        if (!Arrays.stream(CloudType.values()).allMatch(cloudTypeMap::containsKey)) return false;
        if (cloudTypeMap.values().stream().allMatch(value -> value == false)) return false;
        return true;
    }

    @Override
    public Object mapStringToObject(String cloudTypeMap) {
        return Jsons.readValue(cloudTypeMap, MAP_TYPE_REFERENCE);
    }

    @Override
    protected Object getDefaultPluginSettings() {
        return ImmutableMap.of((Object)((Object)CloudType.FEDRAMP), (Object)false, (Object)((Object)CloudType.STANDARD), (Object)true);
    }
}

