/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.fx3.Fx3Client;
import com.atlassian.migration.agent.service.featureflag.Fx3ClientHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlagClient {
    private Fx3Client fx3Client = null;
    private static final Logger log = LoggerFactory.getLogger(FeatureFlagClient.class);

    public FeatureFlagClient(Fx3ClientHandler fx3ClientHandler) {
        try {
            this.fx3Client = fx3ClientHandler.getFx3Client();
        }
        catch (Exception e) {
            log.error("Error occurred while initializing FeatureFlagClient with message : {}", (Object)e.getMessage());
        }
    }

    public void updateCloudId(String cloudId) {
        try {
            this.fx3Client.updateUserIdentifier(cloudId);
            this.fx3Client.performManualFetch();
        }
        catch (Exception e) {
            log.error("Error occurred while updating cloud id with message : {}", (Object)e.getMessage());
        }
    }

    public boolean isFeatureEnabled(String flagKey) {
        try {
            return this.fx3Client.getAllEnabledFlagsForUser().contains(flagKey);
        }
        catch (Exception e) {
            log.error("Error occurred while checking feature flag with message : {}", (Object)e.getMessage());
            return false;
        }
    }

    List<String> getAllEnabledFeatureFlags() {
        try {
            Set result = this.fx3Client.getAllEnabledFlagsForUser();
            return new ArrayList<String>(result);
        }
        catch (Exception e) {
            log.error("Error occurred while getting all enabled feature flags with message : {}", (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }
}

