/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.migration.agent.entity.IncorrectEmail;
import com.atlassian.migration.agent.service.email.ActionOnMigration;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
public class IncorrectEmailDTO {
    @Nullable
    @JsonProperty
    private final String currentEmail;
    @JsonProperty
    private final String userName;
    @JsonProperty
    private final ActionOnMigration actionOnMigration;
    @JsonProperty
    private final String directoryName;
    @Nullable
    @JsonProperty
    private final Long lastAuthenticated;

    public IncorrectEmailDTO(@Nullable String currentEmail, String userName, ActionOnMigration actionOnMigration, String directoryName, @Nullable Long lastAuthenticated) {
        this.currentEmail = currentEmail;
        this.userName = userName;
        this.actionOnMigration = actionOnMigration;
        this.directoryName = directoryName;
        this.lastAuthenticated = lastAuthenticated;
    }

    @Nullable
    public String getCurrentEmail() {
        return this.currentEmail;
    }

    public String getUserName() {
        return this.userName;
    }

    public ActionOnMigration getActionOnMigration() {
        return this.actionOnMigration;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    @Nullable
    public Long getLastAuthenticated() {
        return this.lastAuthenticated;
    }

    public static IncorrectEmailDTO fromIncorrectEmail(IncorrectEmail incorrectEmail, ActionOnMigration actionOnMigration) {
        return new IncorrectEmailDTO(incorrectEmail.getEmail(), incorrectEmail.getUserName(), actionOnMigration, incorrectEmail.getDirectoryName(), incorrectEmail.getLastAuthenticated());
    }
}

