/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.template;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.agent.entity.GlobalEntityType;
import com.atlassian.migration.agent.service.NonSpaceTemplateConflictsInfo;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.check.template.GlobalDataTemplateConflictContext;
import com.atlassian.migration.agent.service.confluence.ConfluenceCloudService;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalDataTemplateConflictChecker
implements Checker<GlobalDataTemplateConflictContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalDataTemplateConflictChecker.class);
    private static Set<GlobalEntityType> applicableGlobalEntityTypes = ImmutableSet.of((Object)((Object)GlobalEntityType.SYSTEM_TEMPLATES), (Object)((Object)GlobalEntityType.GLOBAL_TEMPLATES), (Object)((Object)GlobalEntityType.GLOBAL_SYSTEM_TEMPLATES));
    private static final String VIOLATIONS_KEY = "violations";
    private final ConfluenceCloudService confluenceCloudService;

    public GlobalDataTemplateConflictChecker(ConfluenceCloudService confluenceCloudService) {
        this.confluenceCloudService = confluenceCloudService;
    }

    public CheckResult check(GlobalDataTemplateConflictContext ctx) {
        try {
            GlobalEntityType globalEntityType = GlobalEntityType.valueOf(ctx.getTemplateType());
            NonSpaceTemplateConflictsInfo conflictsInfo = this.confluenceCloudService.getNonSpaceTemplateConflictsInfo(globalEntityType, ctx.cloudId);
            return new CheckResult(conflictsInfo.getConflicts().isEmpty(), Collections.singletonMap(VIOLATIONS_KEY, conflictsInfo.getConflicts()));
        }
        catch (RuntimeException exception) {
            log.error("Error executing global data template conflict check.", (Throwable)exception);
            return Checker.buildCheckResultWithExecutionError((int)PreflightErrorCode.GLOBAL_SYSTEM_TEMPLATE_CHECK_ERROR.getCode());
        }
    }

    public static boolean isApplicable(GlobalEntityType globalEntityType) {
        return applicableGlobalEntityTypes.contains((Object)globalEntityType);
    }
}

