/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.export;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.importexport.impl.ExportScope;
import com.atlassian.confluence.importexport.impl.XmlExporter;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.migration.agent.export.MigrationExportException;
import com.atlassian.migration.agent.export.MigrationExportFileNameGenerator;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class SpaceNoAttachmentsXmlExporter {
    private final SpaceManager spaceManager;
    private final ExportDirManager exportDirManager;
    private final Supplier<XmlExporter> xmlExporterSupplier;
    private final Supplier<ProgressMeter> progressMeterSupplier;
    private final Executor oneAtATimeExecutor = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)this.getClass().getName()));
    private final TransactionTemplate transactionTemplate;

    public SpaceNoAttachmentsXmlExporter(SpaceManager spaceManager, ExportDirManager exportDirManager, TransactionTemplate transactionTemplate) {
        this(spaceManager, exportDirManager, transactionTemplate, () -> (XmlExporter)ComponentLocator.getComponent(XmlExporter.class), ProgressMeter::new);
    }

    @VisibleForTesting
    SpaceNoAttachmentsXmlExporter(SpaceManager spaceManager, ExportDirManager exportDirManager, TransactionTemplate transactionTemplate, Supplier<XmlExporter> xmlExporterSupplier, Supplier<ProgressMeter> progressMeterSupplier) {
        this.spaceManager = spaceManager;
        this.exportDirManager = exportDirManager;
        this.transactionTemplate = transactionTemplate;
        this.xmlExporterSupplier = xmlExporterSupplier;
        this.progressMeterSupplier = progressMeterSupplier;
    }

    public CompletableFuture<String> doExport(String spaceKey, String exportFileId) {
        return CompletableFuture.supplyAsync(() -> this.doExportImpl(spaceKey, exportFileId), this.oneAtATimeExecutor);
    }

    @VisibleForTesting
    String doExportImpl(String spaceKey, String exportFileId) {
        XmlExporter xmlExporter = this.configureXmlExporter(spaceKey, exportFileId);
        return this.doExportWrappingInTx(xmlExporter, spaceKey);
    }

    @VisibleForTesting
    XmlExporter configureXmlExporter(String spaceKey, String fileId) {
        XmlExporter xmlExporter = this.xmlExporterSupplier.get();
        xmlExporter.setExportFileNameGenerator((ExportFileNameGenerator)new MigrationExportFileNameGenerator(this.exportDirManager, fileId));
        xmlExporter.setContext(this.buildExportContext(spaceKey));
        return xmlExporter;
    }

    private ExportContext buildExportContext(String spaceKey) {
        DefaultExportContext exportContext = new DefaultExportContext();
        exportContext.addWorkingEntity((ConfluenceEntityObject)this.spaceManager.getSpace(spaceKey));
        exportContext.setSpaceKey(spaceKey);
        exportContext.setExportScope(ExportScope.SPACE);
        exportContext.setExportAll(true);
        exportContext.setExportAttachments(false);
        return exportContext;
    }

    private String doExportWrappingInTx(XmlExporter exporter, String spaceKey) {
        return (String)this.transactionTemplate.execute(() -> {
            String pathToExportFile;
            ProgressMeter progressMeter = this.progressMeterSupplier.get();
            try {
                pathToExportFile = exporter.doExport(progressMeter);
            }
            catch (ImportExportException ex) {
                throw new MigrationExportException(String.format("Failed to export space %s", spaceKey), ex);
            }
            if (!progressMeter.isCompletedSuccessfully()) {
                throw new MigrationExportException(String.format("Export of space %s did not complete successfully.", spaceKey));
            }
            return pathToExportFile;
        });
    }
}

