/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="MIG_SPACE_STATISTIC")
public class SpaceStatistic {
    @Id
    @Column(name="spaceId", nullable=false)
    private long spaceId;
    @Column(name="attachmentSize", nullable=false)
    private long attachmentSize;
    @Column(name="attachmentCount", nullable=false)
    private long attachmentCount;
    @Column(name="sumOfPageBlogDraftCount", nullable=false)
    private long sumOfPageBlogDraftCount;
    @Column(name="lastUpdated")
    private Instant lastUpdated;
    @Column(name="estimatedMigrationTime", nullable=false)
    private long estimatedMigrationTime;
    @Column(name="lastCalculated", nullable=false)
    private Instant lastCalculated;

    public SpaceStatistic(long spaceId, long sumOfPageBlogDraftCount, long attachmentCount, long attachmentSize, Instant lastUpdated, Instant lastCalculated) {
        this.spaceId = spaceId;
        this.sumOfPageBlogDraftCount = sumOfPageBlogDraftCount;
        this.attachmentCount = attachmentCount;
        this.attachmentSize = attachmentSize;
        this.lastUpdated = lastUpdated;
        this.estimatedMigrationTime = MigrationTimeEstimationUtils.estimateSpaceMigrationTime(sumOfPageBlogDraftCount, attachmentSize);
        this.lastCalculated = lastCalculated;
    }

    @Generated
    public SpaceStatistic() {
    }

    @Generated
    public long getSpaceId() {
        return this.spaceId;
    }

    @Generated
    public long getAttachmentSize() {
        return this.attachmentSize;
    }

    @Generated
    public long getAttachmentCount() {
        return this.attachmentCount;
    }

    @Generated
    public long getSumOfPageBlogDraftCount() {
        return this.sumOfPageBlogDraftCount;
    }

    @Generated
    public Instant getLastUpdated() {
        return this.lastUpdated;
    }

    @Generated
    public long getEstimatedMigrationTime() {
        return this.estimatedMigrationTime;
    }

    @Generated
    public Instant getLastCalculated() {
        return this.lastCalculated;
    }

    @Generated
    public void setSpaceId(long spaceId) {
        this.spaceId = spaceId;
    }

    @Generated
    public void setAttachmentSize(long attachmentSize) {
        this.attachmentSize = attachmentSize;
    }

    @Generated
    public void setAttachmentCount(long attachmentCount) {
        this.attachmentCount = attachmentCount;
    }

    @Generated
    public void setSumOfPageBlogDraftCount(long sumOfPageBlogDraftCount) {
        this.sumOfPageBlogDraftCount = sumOfPageBlogDraftCount;
    }

    @Generated
    public void setLastUpdated(Instant lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Generated
    public void setEstimatedMigrationTime(long estimatedMigrationTime) {
        this.estimatedMigrationTime = estimatedMigrationTime;
    }

    @Generated
    public void setLastCalculated(Instant lastCalculated) {
        this.lastCalculated = lastCalculated;
    }
}

