/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.results.TotalAttachmentsPerPageQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;

public class TotalAttachmentsPerPageQuery
implements GrQuery<TotalAttachmentsPerPageQueryResult>,
L1AssessmentQuery<TotalAttachmentsPerPageQueryResult> {
    private static final String TOTAL_ATTACHMENTS_PER_PAGE = "TOTAL_ATTACHMENTS_PER_PAGE";
    private static final int LIMIT = 100;
    private final EntityManagerTemplate tmpl;

    public TotalAttachmentsPerPageQuery(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public String getQueryId() {
        return TOTAL_ATTACHMENTS_PER_PAGE;
    }

    @Override
    public TotalAttachmentsPerPageQueryResult execute() {
        String query = "select content.container.id, count(*) as ct from Content content  where content.type = 'ATTACHMENT'   and content.container.id in (select c.id from Content c where c.type = 'PAGE' and c.previousVersion is null)  group by content.container.id order by ct desc";
        List<Tuple> result = this.tmpl.query(Tuple.class, query).max(100).list();
        return new TotalAttachmentsPerPageQueryResult(result);
    }
}

