/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.stepexecutor.TombstoneMappingsPublisherException;
import com.atlassian.migration.agent.service.stepexecutor.space.PublishTombstoneMappingRequest;
import com.atlassian.migration.agent.service.stepexecutor.space.TombstoneUser;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationRequestBuilder;
import com.atlassian.migration.agent.service.user.UsersMigrationService;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class TombstoneMappingsPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TombstoneMappingsPublisher.class);
    private static final int MAX_TOMBSTONE_ACCOUNTS_PER_REQUEST = 5000;
    private final UsersMigrationService usersMigrationService;
    private final UsersMigrationRequestBuilder usersMigrationRequestBuilder;

    public TombstoneMappingsPublisher(RetryingUsersMigrationService usersMigrationService, UsersMigrationRequestBuilder usersMigrationRequestBuilder) {
        this.usersMigrationService = usersMigrationService;
        this.usersMigrationRequestBuilder = usersMigrationRequestBuilder;
    }

    public Map<String, String> createAndPublishTombstoneMappings(Step step, List<TombstoneUser> tombstoneUsers) throws TombstoneMappingsPublisherException {
        if (tombstoneUsers.isEmpty()) {
            return Collections.emptyMap();
        }
        Plan plan = step.getPlan();
        String migrationScopeId = plan.getMigrationScopeId();
        CloudSite cloudSite = plan.getCloudSite();
        String containerToken = cloudSite.getContainerToken();
        List cleansedTombstoneUsers = tombstoneUsers.stream().map(u -> new TombstoneUser(u.getUserName(), u.getUserKey(), IdentityAcceptedEmailValidator.cleanse((String)u.getEmail()), u.getDisplayName())).collect(Collectors.toList());
        List tombstoneUsersBatches = Lists.partition(cleansedTombstoneUsers, (int)5000);
        try {
            ArrayList<TombstoneUser> tombstoneUsersWithAaids = new ArrayList<TombstoneUser>();
            for (List tombstoneUsersBatch : tombstoneUsersBatches) {
                List<String> aaidsForTombstoneUsers = this.usersMigrationService.createTombstoneAccounts(containerToken, tombstoneUsersBatch.size(), this.usersMigrationRequestBuilder.createTombstoneAccountCreationRequest(cloudSite)).getTombstoneAccountIds();
                PublishTombstoneMappingRequest requestForPublishingTombstoneMappings = this.usersMigrationRequestBuilder.createRequestForPublishingTombstoneMappings(migrationScopeId, tombstoneUsersBatch, aaidsForTombstoneUsers);
                tombstoneUsersWithAaids.addAll(requestForPublishingTombstoneMappings.getTombstoneUsers());
                this.usersMigrationService.publishTombstoneMappings(containerToken, requestForPublishingTombstoneMappings);
            }
            return tombstoneUsersWithAaids.stream().collect(Collectors.toMap(TombstoneUser::getEmail, TombstoneUser::getAaid));
        }
        catch (Exception e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                log.warn("Creating and publishing tombstone mappings failed due to Migration Step being stopped", (Throwable)e);
                throw new UncheckedInterruptedException(e);
            }
            log.error("An error occurred while creating and publishing tombstone mappings.", (Throwable)e);
            throw new TombstoneMappingsPublisherException(e);
        }
    }
}

