/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.impl.SpaceStatisticCalculationService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import javax.inject.Named;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="SpaceStatisticCalculationExecutor")
public class SpaceStatisticCalculationIntervalExecutor
implements JobRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceStatisticCalculationIntervalExecutor.class);
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final SpaceStatisticCalculationService spaceStatisticCalculationService;

    public SpaceStatisticCalculationIntervalExecutor(SpaceStatisticCalculationService spaceStatisticCalculationService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.spaceStatisticCalculationService = spaceStatisticCalculationService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        if (this.migrationDarkFeaturesManager.isNewSpaceSelectorEnabled()) {
            JobId jobId = request.getJobId();
            log.info("Running space statistic calculation job. jobId: {}", (Object)jobId);
            try {
                this.spaceStatisticCalculationService.runSpaceStatisticCalculation(jobId, true, false);
                return JobRunnerResponse.success((String)"Ran space statistic calculation.");
            }
            catch (Exception e) {
                return JobRunnerResponse.failed((String)("Failed to run space statistic calculation." + e.getMessage()));
            }
        }
        return JobRunnerResponse.success((String)"Skipped space statistic calculation as feature flag is not enabled");
    }
}

