/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.email.UserBaseScanRunner;
import com.atlassian.migration.agent.service.email.UserBaseScanService;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Path(value="userbase")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserBaseScanResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserBaseScanResource.class);
    private final UserBaseScanRunner userBaseScanRunner;
    private final UserBaseScanService userBaseScanService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final CloudSiteService cloudSiteService;
    private final MigrationPlatformService migrationPlatformService;

    public UserBaseScanResource(UserBaseScanRunner userBaseScanRunner, UserBaseScanService userBaseScanService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, CloudSiteService cloudSiteService, MigrationPlatformService migrationPlatformService) {
        this.userBaseScanRunner = userBaseScanRunner;
        this.userBaseScanService = userBaseScanService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.cloudSiteService = cloudSiteService;
        this.migrationPlatformService = migrationPlatformService;
    }

    @POST
    @Path(value="/scan/{cloudId}")
    public Response scanUserBase(@PathParam(value="cloudId") String cloudId) {
        if (this.isGlobalEmailFixesDisabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<CloudSite> cloudSite = this.cloudSiteService.getByCloudId(cloudId);
        if (!cloudSite.isPresent()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String containerToken = cloudSite.get().getContainerToken();
        if (StringUtils.isBlank((CharSequence)containerToken)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.isTokenValid(containerToken)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("Cloud-token-expired", (Object)"true").build();
        }
        this.userBaseScanRunner.startUserBaseScan(cloudSite.get().getCloudId());
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/scan/summary")
    public Response getScanSummary() {
        if (this.isGlobalEmailFixesDisabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)this.userBaseScanService.getScanSummary()).build();
    }

    private boolean isGlobalEmailFixesDisabled() {
        return !this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes();
    }

    private boolean isTokenValid(String containerToken) {
        try {
            Instant timeToContainerTokenExpiry = this.migrationPlatformService.getContainerTokenExpiry(containerToken).toInstant();
            return timeToContainerTokenExpiry.compareTo(Instant.now()) > 0;
        }
        catch (Exception e) {
            log.error("Error while checking if token: {} is valid, exception {}", (Object)containerToken, (Object)e);
            return false;
        }
    }
}

