/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.guardrails.GrQuery;
import com.atlassian.migration.agent.store.guardrails.L1AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.results.SizeOfTablesQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;
import org.slf4j.Logger;

public class SizeOfTablesQuery
implements GrQuery<SizeOfTablesQueryResult>,
L1AssessmentQuery<SizeOfTablesQueryResult> {
    private static final Logger log = ContextLoggerFactory.getLogger(SizeOfTablesQuery.class);
    private static final String SIZE_OF_TABLES = "SIZE_OF_TABLES";
    private static final int LIMIT = 100;
    private final EntityManagerTemplate tmpl;
    private final BootstrapManager bootstrapManager;

    public SizeOfTablesQuery(EntityManagerTemplate tmpl, BootstrapManager bootstrapManager) {
        this.tmpl = tmpl;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public String getQueryId() {
        return SIZE_OF_TABLES;
    }

    @Override
    public SizeOfTablesQueryResult execute() {
        String query = this.getSizeOfTablesQuery();
        List<Tuple> result = this.tmpl.nativeQuery(Tuple.class, query).list();
        return new SizeOfTablesQueryResult(result);
    }

    String getSizeOfTablesQuery() {
        try {
            ApplicationConfiguration applicationConfig = this.bootstrapManager.getApplicationConfig();
            String dialect = (String)applicationConfig.getProperty((Object)"hibernate.dialect");
            log.info("Resolved hibernate dialect: {}", (Object)dialect);
            if (dialect != null && dialect.toLowerCase().contains("postgresql")) {
                return String.format("SELECT cast(C.oid as varchar), nspname || '.' || relname AS \"relation\", pg_relation_size(C.oid) AS \"size_bytes\" \n FROM pg_class C\n LEFT JOIN pg_namespace N ON (N.oid = C.relnamespace) WHERE nspname NOT IN ('pg_catalog', 'information_schema')  ORDER BY pg_relation_size(C.oid) DESC LIMIT %d", 100);
            }
            if (dialect != null && dialect.toLowerCase().contains("oracle")) {
                return String.format("SELECT DS.TABLESPACE_NAME AS \"Database\", SEGMENT_NAME AS \"Table\", ROUND(SUM(DS.BYTES)) AS size_bytes\n  FROM DBA_SEGMENTS DS\n  WHERE SEGMENT_NAME IN (SELECT TABLE_NAME FROM DBA_TABLES)\n  GROUP BY DS.TABLESPACE_NAME,\n  SEGMENT_NAME\n  ORDER BY size_bytes DESC\n  FETCH FIRST %d ROWS ONLY", 100);
            }
            if (dialect != null && dialect.toLowerCase().contains("h2")) {
                return String.format("SELECT table_schema, table_name, ROW_COUNT_ESTIMATE \n FROM information_schema.TABLES \n  ORDER BY ROW_COUNT_ESTIMATE DESC LIMIT %d", 100);
            }
        }
        catch (Exception e) {
            log.debug("{} query failed to retrieve dialect, exception {}", (Object)SIZE_OF_TABLES, (Object)e);
        }
        return String.format("SELECT \n  table_schema as \"Database\", \n  table_name AS \"Table\", \n  round(((data_length + index_length)), 2) \"size_bytes\" \n FROM information_schema.TABLES \n ORDER BY (data_length + index_length) DESC LIMIT %d", 100);
    }
}

